/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.FailureStatusCodeRange;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class CircuitBreakerFailureCondition
implements JsonSerializable<CircuitBreakerFailureCondition> {
    private Long count;
    private Long percentage;
    private Duration interval;
    private List<FailureStatusCodeRange> statusCodeRanges;
    private List<String> errorReasons;

    public Long count() {
        return this.count;
    }

    public CircuitBreakerFailureCondition withCount(Long count) {
        this.count = count;
        return this;
    }

    public Long percentage() {
        return this.percentage;
    }

    public CircuitBreakerFailureCondition withPercentage(Long percentage) {
        this.percentage = percentage;
        return this;
    }

    public Duration interval() {
        return this.interval;
    }

    public CircuitBreakerFailureCondition withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public List<FailureStatusCodeRange> statusCodeRanges() {
        return this.statusCodeRanges;
    }

    public CircuitBreakerFailureCondition withStatusCodeRanges(List<FailureStatusCodeRange> statusCodeRanges) {
        this.statusCodeRanges = statusCodeRanges;
        return this;
    }

    public List<String> errorReasons() {
        return this.errorReasons;
    }

    public CircuitBreakerFailureCondition withErrorReasons(List<String> errorReasons) {
        this.errorReasons = errorReasons;
        return this;
    }

    public void validate() {
        if (this.statusCodeRanges() != null) {
            this.statusCodeRanges().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeNumberField("percentage", (Number)this.percentage);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays((Duration)this.interval));
        jsonWriter.writeArrayField("statusCodeRanges", this.statusCodeRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("errorReasons", this.errorReasons, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CircuitBreakerFailureCondition fromJson(JsonReader jsonReader) throws IOException {
        return (CircuitBreakerFailureCondition)jsonReader.readObject(reader -> {
            CircuitBreakerFailureCondition deserializedCircuitBreakerFailureCondition = new CircuitBreakerFailureCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedCircuitBreakerFailureCondition.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("percentage".equals(fieldName)) {
                    deserializedCircuitBreakerFailureCondition.percentage = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedCircuitBreakerFailureCondition.interval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("statusCodeRanges".equals(fieldName)) {
                    List statusCodeRanges;
                    deserializedCircuitBreakerFailureCondition.statusCodeRanges = statusCodeRanges = reader.readArray(reader1 -> FailureStatusCodeRange.fromJson(reader1));
                    continue;
                }
                if ("errorReasons".equals(fieldName)) {
                    List errorReasons;
                    deserializedCircuitBreakerFailureCondition.errorReasons = errorReasons = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCircuitBreakerFailureCondition;
        });
    }
}

