/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.CircuitBreakerFailureCondition;
import java.io.IOException;
import java.time.Duration;

public final class CircuitBreakerRule
implements JsonSerializable<CircuitBreakerRule> {
    private String name;
    private CircuitBreakerFailureCondition failureCondition;
    private Duration tripDuration;
    private Boolean acceptRetryAfter;

    public String name() {
        return this.name;
    }

    public CircuitBreakerRule withName(String name) {
        this.name = name;
        return this;
    }

    public CircuitBreakerFailureCondition failureCondition() {
        return this.failureCondition;
    }

    public CircuitBreakerRule withFailureCondition(CircuitBreakerFailureCondition failureCondition) {
        this.failureCondition = failureCondition;
        return this;
    }

    public Duration tripDuration() {
        return this.tripDuration;
    }

    public CircuitBreakerRule withTripDuration(Duration tripDuration) {
        this.tripDuration = tripDuration;
        return this;
    }

    public Boolean acceptRetryAfter() {
        return this.acceptRetryAfter;
    }

    public CircuitBreakerRule withAcceptRetryAfter(Boolean acceptRetryAfter) {
        this.acceptRetryAfter = acceptRetryAfter;
        return this;
    }

    public void validate() {
        if (this.failureCondition() != null) {
            this.failureCondition().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("failureCondition", (JsonSerializable)this.failureCondition);
        jsonWriter.writeStringField("tripDuration", CoreUtils.durationToStringWithDays((Duration)this.tripDuration));
        jsonWriter.writeBooleanField("acceptRetryAfter", this.acceptRetryAfter);
        return jsonWriter.writeEndObject();
    }

    public static CircuitBreakerRule fromJson(JsonReader jsonReader) throws IOException {
        return (CircuitBreakerRule)jsonReader.readObject(reader -> {
            CircuitBreakerRule deserializedCircuitBreakerRule = new CircuitBreakerRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCircuitBreakerRule.name = reader.getString();
                    continue;
                }
                if ("failureCondition".equals(fieldName)) {
                    deserializedCircuitBreakerRule.failureCondition = CircuitBreakerFailureCondition.fromJson(reader);
                    continue;
                }
                if ("tripDuration".equals(fieldName)) {
                    deserializedCircuitBreakerRule.tripDuration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("acceptRetryAfter".equals(fieldName)) {
                    deserializedCircuitBreakerRule.acceptRetryAfter = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCircuitBreakerRule;
        });
    }
}

