/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckProtocol;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckRequestDestination;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckRequestProtocolConfiguration;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckRequestSource;
import com.azure.resourcemanager.apimanagement.models.PreferredIpVersion;
import java.io.IOException;

public final class ConnectivityCheckRequest
implements JsonSerializable<ConnectivityCheckRequest> {
    private ConnectivityCheckRequestSource source;
    private ConnectivityCheckRequestDestination destination;
    private PreferredIpVersion preferredIpVersion;
    private ConnectivityCheckProtocol protocol;
    private ConnectivityCheckRequestProtocolConfiguration protocolConfiguration;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityCheckRequest.class);

    public ConnectivityCheckRequestSource source() {
        return this.source;
    }

    public ConnectivityCheckRequest withSource(ConnectivityCheckRequestSource source) {
        this.source = source;
        return this;
    }

    public ConnectivityCheckRequestDestination destination() {
        return this.destination;
    }

    public ConnectivityCheckRequest withDestination(ConnectivityCheckRequestDestination destination) {
        this.destination = destination;
        return this;
    }

    public PreferredIpVersion preferredIpVersion() {
        return this.preferredIpVersion;
    }

    public ConnectivityCheckRequest withPreferredIpVersion(PreferredIpVersion preferredIpVersion) {
        this.preferredIpVersion = preferredIpVersion;
        return this;
    }

    public ConnectivityCheckProtocol protocol() {
        return this.protocol;
    }

    public ConnectivityCheckRequest withProtocol(ConnectivityCheckProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public ConnectivityCheckRequestProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public ConnectivityCheckRequest withProtocolConfiguration(ConnectivityCheckRequestProtocolConfiguration protocolConfiguration) {
        this.protocolConfiguration = protocolConfiguration;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model ConnectivityCheckRequest"));
        }
        this.source().validate();
        if (this.destination() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destination in model ConnectivityCheckRequest"));
        }
        this.destination().validate();
        if (this.protocolConfiguration() != null) {
            this.protocolConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination);
        jsonWriter.writeStringField("preferredIPVersion", this.preferredIpVersion == null ? null : this.preferredIpVersion.toString());
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeJsonField("protocolConfiguration", (JsonSerializable)this.protocolConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityCheckRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityCheckRequest)jsonReader.readObject(reader -> {
            ConnectivityCheckRequest deserializedConnectivityCheckRequest = new ConnectivityCheckRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.source = ConnectivityCheckRequestSource.fromJson(reader);
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.destination = ConnectivityCheckRequestDestination.fromJson(reader);
                    continue;
                }
                if ("preferredIPVersion".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.preferredIpVersion = PreferredIpVersion.fromString(reader.getString());
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.protocol = ConnectivityCheckProtocol.fromString(reader.getString());
                    continue;
                }
                if ("protocolConfiguration".equals(fieldName)) {
                    deserializedConnectivityCheckRequest.protocolConfiguration = ConnectivityCheckRequestProtocolConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityCheckRequest;
        });
    }
}

