/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.HttpHeader;
import com.azure.resourcemanager.apimanagement.models.Method;
import java.io.IOException;
import java.util.List;

public final class ConnectivityCheckRequestProtocolConfigurationHttpConfiguration
implements JsonSerializable<ConnectivityCheckRequestProtocolConfigurationHttpConfiguration> {
    private Method method;
    private List<Long> validStatusCodes;
    private List<HttpHeader> headers;

    public Method method() {
        return this.method;
    }

    public ConnectivityCheckRequestProtocolConfigurationHttpConfiguration withMethod(Method method) {
        this.method = method;
        return this;
    }

    public List<Long> validStatusCodes() {
        return this.validStatusCodes;
    }

    public ConnectivityCheckRequestProtocolConfigurationHttpConfiguration withValidStatusCodes(List<Long> validStatusCodes) {
        this.validStatusCodes = validStatusCodes;
        return this;
    }

    public List<HttpHeader> headers() {
        return this.headers;
    }

    public ConnectivityCheckRequestProtocolConfigurationHttpConfiguration withHeaders(List<HttpHeader> headers) {
        this.headers = headers;
        return this;
    }

    public void validate() {
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeArrayField("validStatusCodes", this.validStatusCodes, (writer, element) -> writer.writeLong(element.longValue()));
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityCheckRequestProtocolConfigurationHttpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityCheckRequestProtocolConfigurationHttpConfiguration)jsonReader.readObject(reader -> {
            ConnectivityCheckRequestProtocolConfigurationHttpConfiguration deserializedConnectivityCheckRequestProtocolConfigurationHttpConfiguration = new ConnectivityCheckRequestProtocolConfigurationHttpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("method".equals(fieldName)) {
                    deserializedConnectivityCheckRequestProtocolConfigurationHttpConfiguration.method = Method.fromString(reader.getString());
                    continue;
                }
                if ("validStatusCodes".equals(fieldName)) {
                    List validStatusCodes;
                    deserializedConnectivityCheckRequestProtocolConfigurationHttpConfiguration.validStatusCodes = validStatusCodes = reader.readArray(reader1 -> reader1.getLong());
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedConnectivityCheckRequestProtocolConfigurationHttpConfiguration.headers = headers = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityCheckRequestProtocolConfigurationHttpConfiguration;
        });
    }
}

