/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ConnectivityIssue;
import java.io.IOException;
import java.util.List;

public final class ConnectivityHop
implements JsonSerializable<ConnectivityHop> {
    private String type;
    private String id;
    private String address;
    private String resourceId;
    private List<String> nextHopIds;
    private List<ConnectivityIssue> issues;

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String address() {
        return this.address;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<String> nextHopIds() {
        return this.nextHopIds;
    }

    public List<ConnectivityIssue> issues() {
        return this.issues;
    }

    public void validate() {
        if (this.issues() != null) {
            this.issues().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityHop fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityHop)jsonReader.readObject(reader -> {
            ConnectivityHop deserializedConnectivityHop = new ConnectivityHop();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedConnectivityHop.type = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedConnectivityHop.id = reader.getString();
                    continue;
                }
                if ("address".equals(fieldName)) {
                    deserializedConnectivityHop.address = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedConnectivityHop.resourceId = reader.getString();
                    continue;
                }
                if ("nextHopIds".equals(fieldName)) {
                    List nextHopIds;
                    deserializedConnectivityHop.nextHopIds = nextHopIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("issues".equals(fieldName)) {
                    List issues;
                    deserializedConnectivityHop.issues = issues = reader.readArray(reader1 -> ConnectivityIssue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityHop;
        });
    }
}

