/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.DiagnosticContractUpdateProperties;
import com.azure.resourcemanager.apimanagement.models.AlwaysLog;
import com.azure.resourcemanager.apimanagement.models.HttpCorrelationProtocol;
import com.azure.resourcemanager.apimanagement.models.OperationNameFormat;
import com.azure.resourcemanager.apimanagement.models.PipelineDiagnosticSettings;
import com.azure.resourcemanager.apimanagement.models.SamplingSettings;
import com.azure.resourcemanager.apimanagement.models.Verbosity;
import java.io.IOException;

public final class DiagnosticUpdateContract
extends ProxyResource {
    private DiagnosticContractUpdateProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DiagnosticContractUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AlwaysLog alwaysLog() {
        return this.innerProperties() == null ? null : this.innerProperties().alwaysLog();
    }

    public DiagnosticUpdateContract withAlwaysLog(AlwaysLog alwaysLog) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withAlwaysLog(alwaysLog);
        return this;
    }

    public String loggerId() {
        return this.innerProperties() == null ? null : this.innerProperties().loggerId();
    }

    public DiagnosticUpdateContract withLoggerId(String loggerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withLoggerId(loggerId);
        return this;
    }

    public SamplingSettings sampling() {
        return this.innerProperties() == null ? null : this.innerProperties().sampling();
    }

    public DiagnosticUpdateContract withSampling(SamplingSettings sampling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withSampling(sampling);
        return this;
    }

    public PipelineDiagnosticSettings frontend() {
        return this.innerProperties() == null ? null : this.innerProperties().frontend();
    }

    public DiagnosticUpdateContract withFrontend(PipelineDiagnosticSettings frontend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withFrontend(frontend);
        return this;
    }

    public PipelineDiagnosticSettings backend() {
        return this.innerProperties() == null ? null : this.innerProperties().backend();
    }

    public DiagnosticUpdateContract withBackend(PipelineDiagnosticSettings backend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withBackend(backend);
        return this;
    }

    public Boolean logClientIp() {
        return this.innerProperties() == null ? null : this.innerProperties().logClientIp();
    }

    public DiagnosticUpdateContract withLogClientIp(Boolean logClientIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withLogClientIp(logClientIp);
        return this;
    }

    public HttpCorrelationProtocol httpCorrelationProtocol() {
        return this.innerProperties() == null ? null : this.innerProperties().httpCorrelationProtocol();
    }

    public DiagnosticUpdateContract withHttpCorrelationProtocol(HttpCorrelationProtocol httpCorrelationProtocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withHttpCorrelationProtocol(httpCorrelationProtocol);
        return this;
    }

    public Verbosity verbosity() {
        return this.innerProperties() == null ? null : this.innerProperties().verbosity();
    }

    public DiagnosticUpdateContract withVerbosity(Verbosity verbosity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withVerbosity(verbosity);
        return this;
    }

    public OperationNameFormat operationNameFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().operationNameFormat();
    }

    public DiagnosticUpdateContract withOperationNameFormat(OperationNameFormat operationNameFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withOperationNameFormat(operationNameFormat);
        return this;
    }

    public Boolean metrics() {
        return this.innerProperties() == null ? null : this.innerProperties().metrics();
    }

    public DiagnosticUpdateContract withMetrics(Boolean metrics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticContractUpdateProperties();
        }
        this.innerProperties().withMetrics(metrics);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticUpdateContract fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticUpdateContract)((Object)jsonReader.readObject(reader -> {
            DiagnosticUpdateContract deserializedDiagnosticUpdateContract = new DiagnosticUpdateContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDiagnosticUpdateContract.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDiagnosticUpdateContract.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDiagnosticUpdateContract.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDiagnosticUpdateContract.innerProperties = DiagnosticContractUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticUpdateContract;
        }));
    }
}

