/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayContractInner;
import com.azure.resourcemanager.apimanagement.models.GatewayDebugCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeyRegenerationRequestContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeysContract;
import com.azure.resourcemanager.apimanagement.models.GatewayListDebugCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.GatewayListTraceContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenRequestContract;
import com.azure.resourcemanager.apimanagement.models.ResourceLocationDataContract;
import java.util.Map;

public interface GatewayContract {
    public String id();

    public String name();

    public String type();

    public ResourceLocationDataContract locationData();

    public String description();

    public String resourceGroupName();

    public GatewayContractInner innerModel();

    public Update update();

    public GatewayContract refresh();

    public GatewayContract refresh(Context var1);

    public Response<GatewayKeysContract> listKeysWithResponse(Context var1);

    public GatewayKeysContract listKeys();

    public Response<Void> regenerateKeyWithResponse(GatewayKeyRegenerationRequestContract var1, Context var2);

    public void regenerateKey(GatewayKeyRegenerationRequestContract var1);

    public Response<GatewayTokenContract> generateTokenWithResponse(GatewayTokenRequestContract var1, Context var2);

    public GatewayTokenContract generateToken(GatewayTokenRequestContract var1);

    public Response<Void> invalidateDebugCredentialsWithResponse(Context var1);

    public void invalidateDebugCredentials();

    public Response<GatewayDebugCredentialsContract> listDebugCredentialsWithResponse(GatewayListDebugCredentialsContract var1, Context var2);

    public GatewayDebugCredentialsContract listDebugCredentials(GatewayListDebugCredentialsContract var1);

    public Response<Map<String, Object>> listTraceWithResponse(GatewayListTraceContract var1, Context var2);

    public Map<String, Object> listTrace(GatewayListTraceContract var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithLocationData {
            public Update withLocationData(ResourceLocationDataContract var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithLocationData,
    UpdateStages.WithDescription,
    UpdateStages.WithIfMatch {
        public GatewayContract apply();

        public GatewayContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithLocationData {
            public WithCreate withLocationData(ResourceLocationDataContract var1);
        }

        public static interface WithCreate
        extends WithLocationData,
        WithDescription,
        WithIfMatch {
            public GatewayContract create();

            public GatewayContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingService(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

