/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class GatewayTokenRequestContract
implements JsonSerializable<GatewayTokenRequestContract> {
    private KeyType keyType;
    private OffsetDateTime expiry;
    private static final ClientLogger LOGGER = new ClientLogger(GatewayTokenRequestContract.class);

    public KeyType keyType() {
        return this.keyType;
    }

    public GatewayTokenRequestContract withKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public OffsetDateTime expiry() {
        return this.expiry;
    }

    public GatewayTokenRequestContract withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    public void validate() {
        if (this.keyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyType in model GatewayTokenRequestContract"));
        }
        if (this.expiry() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property expiry in model GatewayTokenRequestContract"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        jsonWriter.writeStringField("expiry", this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        return jsonWriter.writeEndObject();
    }

    public static GatewayTokenRequestContract fromJson(JsonReader jsonReader) throws IOException {
        return (GatewayTokenRequestContract)jsonReader.readObject(reader -> {
            GatewayTokenRequestContract deserializedGatewayTokenRequestContract = new GatewayTokenRequestContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyType".equals(fieldName)) {
                    deserializedGatewayTokenRequestContract.keyType = KeyType.fromString(reader.getString());
                    continue;
                }
                if ("expiry".equals(fieldName)) {
                    deserializedGatewayTokenRequestContract.expiry = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayTokenRequestContract;
        });
    }
}

