/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderType;
import java.io.IOException;
import java.util.List;

public class IdentityProviderBaseParameters
implements JsonSerializable<IdentityProviderBaseParameters> {
    private IdentityProviderType type;
    private String signinTenant;
    private List<String> allowedTenants;
    private String authority;
    private String signupPolicyName;
    private String signinPolicyName;
    private String profileEditingPolicyName;
    private String passwordResetPolicyName;
    private String clientLibrary;

    public IdentityProviderType type() {
        return this.type;
    }

    public IdentityProviderBaseParameters withType(IdentityProviderType type) {
        this.type = type;
        return this;
    }

    public String signinTenant() {
        return this.signinTenant;
    }

    public IdentityProviderBaseParameters withSigninTenant(String signinTenant) {
        this.signinTenant = signinTenant;
        return this;
    }

    public List<String> allowedTenants() {
        return this.allowedTenants;
    }

    public IdentityProviderBaseParameters withAllowedTenants(List<String> allowedTenants) {
        this.allowedTenants = allowedTenants;
        return this;
    }

    public String authority() {
        return this.authority;
    }

    public IdentityProviderBaseParameters withAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    public String signupPolicyName() {
        return this.signupPolicyName;
    }

    public IdentityProviderBaseParameters withSignupPolicyName(String signupPolicyName) {
        this.signupPolicyName = signupPolicyName;
        return this;
    }

    public String signinPolicyName() {
        return this.signinPolicyName;
    }

    public IdentityProviderBaseParameters withSigninPolicyName(String signinPolicyName) {
        this.signinPolicyName = signinPolicyName;
        return this;
    }

    public String profileEditingPolicyName() {
        return this.profileEditingPolicyName;
    }

    public IdentityProviderBaseParameters withProfileEditingPolicyName(String profileEditingPolicyName) {
        this.profileEditingPolicyName = profileEditingPolicyName;
        return this;
    }

    public String passwordResetPolicyName() {
        return this.passwordResetPolicyName;
    }

    public IdentityProviderBaseParameters withPasswordResetPolicyName(String passwordResetPolicyName) {
        this.passwordResetPolicyName = passwordResetPolicyName;
        return this;
    }

    public String clientLibrary() {
        return this.clientLibrary;
    }

    public IdentityProviderBaseParameters withClientLibrary(String clientLibrary) {
        this.clientLibrary = clientLibrary;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("signinTenant", this.signinTenant);
        jsonWriter.writeArrayField("allowedTenants", this.allowedTenants, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("authority", this.authority);
        jsonWriter.writeStringField("signupPolicyName", this.signupPolicyName);
        jsonWriter.writeStringField("signinPolicyName", this.signinPolicyName);
        jsonWriter.writeStringField("profileEditingPolicyName", this.profileEditingPolicyName);
        jsonWriter.writeStringField("passwordResetPolicyName", this.passwordResetPolicyName);
        jsonWriter.writeStringField("clientLibrary", this.clientLibrary);
        return jsonWriter.writeEndObject();
    }

    public static IdentityProviderBaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityProviderBaseParameters)jsonReader.readObject(reader -> {
            IdentityProviderBaseParameters deserializedIdentityProviderBaseParameters = new IdentityProviderBaseParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIdentityProviderBaseParameters.type = IdentityProviderType.fromString(reader.getString());
                    continue;
                }
                if ("signinTenant".equals(fieldName)) {
                    deserializedIdentityProviderBaseParameters.signinTenant = reader.getString();
                    continue;
                }
                if ("allowedTenants".equals(fieldName)) {
                    List allowedTenants;
                    deserializedIdentityProviderBaseParameters.allowedTenants = allowedTenants = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("authority".equals(fieldName)) {
                    deserializedIdentityProviderBaseParameters.authority = reader.getString();
                    continue;
                }
                if ("signupPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderBaseParameters.signupPolicyName = reader.getString();
                    continue;
                }
                if ("signinPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderBaseParameters.signinPolicyName = reader.getString();
                    continue;
                }
                if ("profileEditingPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderBaseParameters.profileEditingPolicyName = reader.getString();
                    continue;
                }
                if ("passwordResetPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderBaseParameters.passwordResetPolicyName = reader.getString();
                    continue;
                }
                if ("clientLibrary".equals(fieldName)) {
                    deserializedIdentityProviderBaseParameters.clientLibrary = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityProviderBaseParameters;
        });
    }
}

