/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractCreateProperties;
import com.azure.resourcemanager.apimanagement.models.KeyVaultLastAccessStatusContractProperties;
import java.io.IOException;

public final class KeyVaultContractProperties
extends KeyVaultContractCreateProperties {
    private KeyVaultLastAccessStatusContractProperties lastStatus;

    public KeyVaultLastAccessStatusContractProperties lastStatus() {
        return this.lastStatus;
    }

    public KeyVaultContractProperties withLastStatus(KeyVaultLastAccessStatusContractProperties lastStatus) {
        this.lastStatus = lastStatus;
        return this;
    }

    @Override
    public KeyVaultContractProperties withSecretIdentifier(String secretIdentifier) {
        super.withSecretIdentifier(secretIdentifier);
        return this;
    }

    @Override
    public KeyVaultContractProperties withIdentityClientId(String identityClientId) {
        super.withIdentityClientId(identityClientId);
        return this;
    }

    @Override
    public void validate() {
        if (this.lastStatus() != null) {
            this.lastStatus().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretIdentifier", this.secretIdentifier());
        jsonWriter.writeStringField("identityClientId", this.identityClientId());
        jsonWriter.writeJsonField("lastStatus", (JsonSerializable)this.lastStatus);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultContractProperties)jsonReader.readObject(reader -> {
            KeyVaultContractProperties deserializedKeyVaultContractProperties = new KeyVaultContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("secretIdentifier".equals(fieldName)) {
                    deserializedKeyVaultContractProperties.withSecretIdentifier(reader.getString());
                    continue;
                }
                if ("identityClientId".equals(fieldName)) {
                    deserializedKeyVaultContractProperties.withIdentityClientId(reader.getString());
                    continue;
                }
                if ("lastStatus".equals(fieldName)) {
                    deserializedKeyVaultContractProperties.lastStatus = KeyVaultLastAccessStatusContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultContractProperties;
        });
    }
}

