/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueCreateContractProperties;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractCreateProperties;
import java.io.IOException;
import java.util.List;

public final class NamedValueCreateContract
extends ProxyResource {
    private NamedValueCreateContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private NamedValueCreateContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public NamedValueCreateContract withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueCreateContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public NamedValueCreateContract withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueCreateContractProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    public KeyVaultContractCreateProperties keyVault() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVault();
    }

    public NamedValueCreateContract withKeyVault(KeyVaultContractCreateProperties keyVault) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueCreateContractProperties();
        }
        this.innerProperties().withKeyVault(keyVault);
        return this;
    }

    public List<String> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    public NamedValueCreateContract withTags(List<String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueCreateContractProperties();
        }
        this.innerProperties().withTags((List)tags);
        return this;
    }

    public Boolean secret() {
        return this.innerProperties() == null ? null : this.innerProperties().secret();
    }

    public NamedValueCreateContract withSecret(Boolean secret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueCreateContractProperties();
        }
        this.innerProperties().withSecret(secret);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NamedValueCreateContract fromJson(JsonReader jsonReader) throws IOException {
        return (NamedValueCreateContract)((Object)jsonReader.readObject(reader -> {
            NamedValueCreateContract deserializedNamedValueCreateContract = new NamedValueCreateContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNamedValueCreateContract.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNamedValueCreateContract.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNamedValueCreateContract.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNamedValueCreateContract.innerProperties = NamedValueCreateContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamedValueCreateContract;
        }));
    }
}

