/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ParameterContract;
import com.azure.resourcemanager.apimanagement.models.RequestContract;
import com.azure.resourcemanager.apimanagement.models.ResponseContract;
import java.io.IOException;
import java.util.List;

public class OperationEntityBaseContract
implements JsonSerializable<OperationEntityBaseContract> {
    private List<ParameterContract> templateParameters;
    private String description;
    private RequestContract request;
    private List<ResponseContract> responses;
    private String policies;

    public List<ParameterContract> templateParameters() {
        return this.templateParameters;
    }

    public OperationEntityBaseContract withTemplateParameters(List<ParameterContract> templateParameters) {
        this.templateParameters = templateParameters;
        return this;
    }

    public String description() {
        return this.description;
    }

    public OperationEntityBaseContract withDescription(String description) {
        this.description = description;
        return this;
    }

    public RequestContract request() {
        return this.request;
    }

    public OperationEntityBaseContract withRequest(RequestContract request) {
        this.request = request;
        return this;
    }

    public List<ResponseContract> responses() {
        return this.responses;
    }

    public OperationEntityBaseContract withResponses(List<ResponseContract> responses) {
        this.responses = responses;
        return this;
    }

    public String policies() {
        return this.policies;
    }

    public OperationEntityBaseContract withPolicies(String policies) {
        this.policies = policies;
        return this;
    }

    public void validate() {
        if (this.templateParameters() != null) {
            this.templateParameters().forEach(e -> e.validate());
        }
        if (this.request() != null) {
            this.request().validate();
        }
        if (this.responses() != null) {
            this.responses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("templateParameters", this.templateParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("request", (JsonSerializable)this.request);
        jsonWriter.writeArrayField("responses", this.responses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("policies", this.policies);
        return jsonWriter.writeEndObject();
    }

    public static OperationEntityBaseContract fromJson(JsonReader jsonReader) throws IOException {
        return (OperationEntityBaseContract)jsonReader.readObject(reader -> {
            OperationEntityBaseContract deserializedOperationEntityBaseContract = new OperationEntityBaseContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("templateParameters".equals(fieldName)) {
                    List templateParameters;
                    deserializedOperationEntityBaseContract.templateParameters = templateParameters = reader.readArray(reader1 -> ParameterContract.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOperationEntityBaseContract.description = reader.getString();
                    continue;
                }
                if ("request".equals(fieldName)) {
                    deserializedOperationEntityBaseContract.request = RequestContract.fromJson(reader);
                    continue;
                }
                if ("responses".equals(fieldName)) {
                    List responses;
                    deserializedOperationEntityBaseContract.responses = responses = reader.readArray(reader1 -> ResponseContract.fromJson(reader1));
                    continue;
                }
                if ("policies".equals(fieldName)) {
                    deserializedOperationEntityBaseContract.policies = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationEntityBaseContract;
        });
    }
}

