/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.EndpointDependency;
import java.io.IOException;
import java.util.List;

public final class OutboundEnvironmentEndpoint
implements JsonSerializable<OutboundEnvironmentEndpoint> {
    private String category;
    private List<EndpointDependency> endpoints;

    public String category() {
        return this.category;
    }

    public OutboundEnvironmentEndpoint withCategory(String category) {
        this.category = category;
        return this;
    }

    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

    public OutboundEnvironmentEndpoint withEndpoints(List<EndpointDependency> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public void validate() {
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OutboundEnvironmentEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (OutboundEnvironmentEndpoint)jsonReader.readObject(reader -> {
            OutboundEnvironmentEndpoint deserializedOutboundEnvironmentEndpoint = new OutboundEnvironmentEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    deserializedOutboundEnvironmentEndpoint.category = reader.getString();
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedOutboundEnvironmentEndpoint.endpoints = endpoints = reader.readArray(reader1 -> EndpointDependency.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOutboundEnvironmentEndpoint;
        });
    }
}

