/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductState;

public interface ProductContract {
    public String id();

    public String name();

    public String type();

    public String displayName();

    public String description();

    public String terms();

    public Boolean subscriptionRequired();

    public Boolean approvalRequired();

    public Integer subscriptionsLimit();

    public ProductState state();

    public String resourceGroupName();

    public ProductContractInner innerModel();

    public Update update();

    public ProductContract refresh();

    public ProductContract refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithState {
            public Update withState(ProductState var1);
        }

        public static interface WithSubscriptionsLimit {
            public Update withSubscriptionsLimit(Integer var1);
        }

        public static interface WithApprovalRequired {
            public Update withApprovalRequired(Boolean var1);
        }

        public static interface WithSubscriptionRequired {
            public Update withSubscriptionRequired(Boolean var1);
        }

        public static interface WithTerms {
            public Update withTerms(String var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDisplayName,
    UpdateStages.WithDescription,
    UpdateStages.WithTerms,
    UpdateStages.WithSubscriptionRequired,
    UpdateStages.WithApprovalRequired,
    UpdateStages.WithSubscriptionsLimit,
    UpdateStages.WithState,
    UpdateStages.WithIfMatch {
        public ProductContract apply();

        public ProductContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithState {
            public WithCreate withState(ProductState var1);
        }

        public static interface WithSubscriptionsLimit {
            public WithCreate withSubscriptionsLimit(Integer var1);
        }

        public static interface WithApprovalRequired {
            public WithCreate withApprovalRequired(Boolean var1);
        }

        public static interface WithSubscriptionRequired {
            public WithCreate withSubscriptionRequired(Boolean var1);
        }

        public static interface WithTerms {
            public WithCreate withTerms(String var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithCreate
        extends WithDisplayName,
        WithDescription,
        WithTerms,
        WithSubscriptionRequired,
        WithApprovalRequired,
        WithSubscriptionsLimit,
        WithState,
        WithIfMatch {
            public ProductContract create();

            public ProductContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingService(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

