/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.PrivateEndpointConnectionWrapperProperties;
import com.azure.resourcemanager.apimanagement.models.ArmIdWrapper;
import com.azure.resourcemanager.apimanagement.models.PrivateLinkServiceConnectionState;
import java.io.IOException;
import java.util.List;

public final class RemotePrivateEndpointConnectionWrapper
implements JsonSerializable<RemotePrivateEndpointConnectionWrapper> {
    private String id;
    private String name;
    private String type;
    private PrivateEndpointConnectionWrapperProperties innerProperties;

    public String id() {
        return this.id;
    }

    public RemotePrivateEndpointConnectionWrapper withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public RemotePrivateEndpointConnectionWrapper withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public RemotePrivateEndpointConnectionWrapper withType(String type) {
        this.type = type;
        return this;
    }

    private PrivateEndpointConnectionWrapperProperties innerProperties() {
        return this.innerProperties;
    }

    public ArmIdWrapper privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    public RemotePrivateEndpointConnectionWrapper withPrivateEndpoint(ArmIdWrapper privateEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointConnectionWrapperProperties();
        }
        this.innerProperties().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public RemotePrivateEndpointConnectionWrapper withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointConnectionWrapperProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> groupIds() {
        return this.innerProperties() == null ? null : this.innerProperties().groupIds();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RemotePrivateEndpointConnectionWrapper fromJson(JsonReader jsonReader) throws IOException {
        return (RemotePrivateEndpointConnectionWrapper)jsonReader.readObject(reader -> {
            RemotePrivateEndpointConnectionWrapper deserializedRemotePrivateEndpointConnectionWrapper = new RemotePrivateEndpointConnectionWrapper();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionWrapper.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionWrapper.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionWrapper.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionWrapper.innerProperties = PrivateEndpointConnectionWrapperProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRemotePrivateEndpointConnectionWrapper;
        });
    }
}

