/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ParameterContract;
import com.azure.resourcemanager.apimanagement.models.RepresentationContract;
import java.io.IOException;
import java.util.List;

public final class RequestContract
implements JsonSerializable<RequestContract> {
    private String description;
    private List<ParameterContract> queryParameters;
    private List<ParameterContract> headers;
    private List<RepresentationContract> representations;

    public String description() {
        return this.description;
    }

    public RequestContract withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ParameterContract> queryParameters() {
        return this.queryParameters;
    }

    public RequestContract withQueryParameters(List<ParameterContract> queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public List<ParameterContract> headers() {
        return this.headers;
    }

    public RequestContract withHeaders(List<ParameterContract> headers) {
        this.headers = headers;
        return this;
    }

    public List<RepresentationContract> representations() {
        return this.representations;
    }

    public RequestContract withRepresentations(List<RepresentationContract> representations) {
        this.representations = representations;
        return this;
    }

    public void validate() {
        if (this.queryParameters() != null) {
            this.queryParameters().forEach(e -> e.validate());
        }
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
        if (this.representations() != null) {
            this.representations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("queryParameters", this.queryParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("representations", this.representations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RequestContract fromJson(JsonReader jsonReader) throws IOException {
        return (RequestContract)jsonReader.readObject(reader -> {
            RequestContract deserializedRequestContract = new RequestContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedRequestContract.description = reader.getString();
                    continue;
                }
                if ("queryParameters".equals(fieldName)) {
                    List queryParameters;
                    deserializedRequestContract.queryParameters = queryParameters = reader.readArray(reader1 -> ParameterContract.fromJson(reader1));
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedRequestContract.headers = headers = reader.readArray(reader1 -> ParameterContract.fromJson(reader1));
                    continue;
                }
                if ("representations".equals(fieldName)) {
                    List representations;
                    deserializedRequestContract.representations = representations = reader.readArray(reader1 -> RepresentationContract.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestContract;
        });
    }
}

