/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResourceLocationDataContract
implements JsonSerializable<ResourceLocationDataContract> {
    private String name;
    private String city;
    private String district;
    private String countryOrRegion;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceLocationDataContract.class);

    public String name() {
        return this.name;
    }

    public ResourceLocationDataContract withName(String name) {
        this.name = name;
        return this;
    }

    public String city() {
        return this.city;
    }

    public ResourceLocationDataContract withCity(String city) {
        this.city = city;
        return this;
    }

    public String district() {
        return this.district;
    }

    public ResourceLocationDataContract withDistrict(String district) {
        this.district = district;
        return this;
    }

    public String countryOrRegion() {
        return this.countryOrRegion;
    }

    public ResourceLocationDataContract withCountryOrRegion(String countryOrRegion) {
        this.countryOrRegion = countryOrRegion;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ResourceLocationDataContract"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("city", this.city);
        jsonWriter.writeStringField("district", this.district);
        jsonWriter.writeStringField("countryOrRegion", this.countryOrRegion);
        return jsonWriter.writeEndObject();
    }

    public static ResourceLocationDataContract fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceLocationDataContract)jsonReader.readObject(reader -> {
            ResourceLocationDataContract deserializedResourceLocationDataContract = new ResourceLocationDataContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceLocationDataContract.name = reader.getString();
                    continue;
                }
                if ("city".equals(fieldName)) {
                    deserializedResourceLocationDataContract.city = reader.getString();
                    continue;
                }
                if ("district".equals(fieldName)) {
                    deserializedResourceLocationDataContract.district = reader.getString();
                    continue;
                }
                if ("countryOrRegion".equals(fieldName)) {
                    deserializedResourceLocationDataContract.countryOrRegion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceLocationDataContract;
        });
    }
}

