/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ResourceSkuResultInner;
import java.io.IOException;
import java.util.List;

public final class ResourceSkuResults
implements JsonSerializable<ResourceSkuResults> {
    private List<ResourceSkuResultInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceSkuResults.class);

    public List<ResourceSkuResultInner> value() {
        return this.value;
    }

    public ResourceSkuResults withValue(List<ResourceSkuResultInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ResourceSkuResults withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ResourceSkuResults"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkuResults fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSkuResults)jsonReader.readObject(reader -> {
            ResourceSkuResults deserializedResourceSkuResults = new ResourceSkuResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceSkuResults.value = value = reader.readArray(reader1 -> ResourceSkuResultInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceSkuResults.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkuResults;
        });
    }
}

