/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractProperties;
import com.azure.resourcemanager.apimanagement.fluent.models.UserContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.models.AppType;
import com.azure.resourcemanager.apimanagement.models.Confirmation;
import com.azure.resourcemanager.apimanagement.models.GenerateSsoUrlResult;
import com.azure.resourcemanager.apimanagement.models.UserIdentityContract;
import com.azure.resourcemanager.apimanagement.models.UserState;
import com.azure.resourcemanager.apimanagement.models.UserTokenParameters;
import com.azure.resourcemanager.apimanagement.models.UserTokenResult;
import java.time.OffsetDateTime;
import java.util.List;

public interface UserContract {
    public String id();

    public String name();

    public String type();

    public String firstName();

    public String lastName();

    public String email();

    public OffsetDateTime registrationDate();

    public List<GroupContractProperties> groups();

    public UserState state();

    public String note();

    public List<UserIdentityContract> identities();

    public String resourceGroupName();

    public UserContractInner innerModel();

    public Update update();

    public UserContract refresh();

    public UserContract refresh(Context var1);

    public Response<GenerateSsoUrlResult> generateSsoUrlWithResponse(Context var1);

    public GenerateSsoUrlResult generateSsoUrl();

    public Response<UserTokenResult> getSharedAccessTokenWithResponse(UserTokenParameters var1, Context var2);

    public UserTokenResult getSharedAccessToken(UserTokenParameters var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithIdentities {
            public Update withIdentities(List<UserIdentityContractInner> var1);
        }

        public static interface WithNote {
            public Update withNote(String var1);
        }

        public static interface WithState {
            public Update withState(UserState var1);
        }

        public static interface WithLastName {
            public Update withLastName(String var1);
        }

        public static interface WithFirstName {
            public Update withFirstName(String var1);
        }

        public static interface WithPassword {
            public Update withPassword(String var1);
        }

        public static interface WithEmail {
            public Update withEmail(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithEmail,
    UpdateStages.WithPassword,
    UpdateStages.WithFirstName,
    UpdateStages.WithLastName,
    UpdateStages.WithState,
    UpdateStages.WithNote,
    UpdateStages.WithIdentities,
    UpdateStages.WithIfMatch {
        public UserContract apply();

        public UserContract apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithNotify {
            public WithCreate withNotify(Boolean var1);
        }

        public static interface WithIdentities {
            public WithCreate withIdentities(List<UserIdentityContractInner> var1);
        }

        public static interface WithNote {
            public WithCreate withNote(String var1);
        }

        public static interface WithState {
            public WithCreate withState(UserState var1);
        }

        public static interface WithConfirmation {
            public WithCreate withConfirmation(Confirmation var1);
        }

        public static interface WithAppType {
            public WithCreate withAppType(AppType var1);
        }

        public static interface WithPassword {
            public WithCreate withPassword(String var1);
        }

        public static interface WithLastName {
            public WithCreate withLastName(String var1);
        }

        public static interface WithFirstName {
            public WithCreate withFirstName(String var1);
        }

        public static interface WithEmail {
            public WithCreate withEmail(String var1);
        }

        public static interface WithCreate
        extends WithEmail,
        WithFirstName,
        WithLastName,
        WithPassword,
        WithAppType,
        WithConfirmation,
        WithState,
        WithNote,
        WithIdentities,
        WithNotify,
        WithIfMatch {
            public UserContract create();

            public UserContract create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingService(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

