/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.models.UserState;
import java.io.IOException;
import java.util.List;

public class UserEntityBaseParameters
implements JsonSerializable<UserEntityBaseParameters> {
    private UserState state;
    private String note;
    private List<UserIdentityContractInner> identities;

    public UserState state() {
        return this.state;
    }

    public UserEntityBaseParameters withState(UserState state) {
        this.state = state;
        return this;
    }

    public String note() {
        return this.note;
    }

    public UserEntityBaseParameters withNote(String note) {
        this.note = note;
        return this;
    }

    public List<UserIdentityContractInner> identities() {
        return this.identities;
    }

    public UserEntityBaseParameters withIdentities(List<UserIdentityContractInner> identities) {
        this.identities = identities;
        return this;
    }

    public void validate() {
        if (this.identities() != null) {
            this.identities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("note", this.note);
        jsonWriter.writeArrayField("identities", this.identities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static UserEntityBaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return (UserEntityBaseParameters)jsonReader.readObject(reader -> {
            UserEntityBaseParameters deserializedUserEntityBaseParameters = new UserEntityBaseParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedUserEntityBaseParameters.state = UserState.fromString(reader.getString());
                    continue;
                }
                if ("note".equals(fieldName)) {
                    deserializedUserEntityBaseParameters.note = reader.getString();
                    continue;
                }
                if ("identities".equals(fieldName)) {
                    List identities;
                    deserializedUserEntityBaseParameters.identities = identities = reader.readArray(reader1 -> UserIdentityContractInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserEntityBaseParameters;
        });
    }
}

