/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.AppConfigurationStoreHealth;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.appconfiguration.config.implementation.ConnectionManager;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppConfigurationReplicaClientFactory {
    private static final Map<String, ConnectionManager> CONNECTIONS = new HashMap<String, ConnectionManager>();
    private final List<ConfigStore> configStores;

    AppConfigurationReplicaClientFactory(AppConfigurationReplicaClientsBuilder clientBuilder, List<ConfigStore> configStores, ReplicaLookUp replicaLookUp) {
        this.configStores = configStores;
        if (CONNECTIONS.isEmpty()) {
            for (ConfigStore store : configStores) {
                ConnectionManager manager = new ConnectionManager(clientBuilder, store, replicaLookUp);
                CONNECTIONS.put(manager.getMainEndpoint(), manager);
            }
        }
    }

    public Map<String, ConnectionManager> getConnections() {
        return CONNECTIONS;
    }

    List<AppConfigurationReplicaClient> getAvailableClients(String originEndpoint) {
        return this.getAvailableClients(originEndpoint, false);
    }

    List<AppConfigurationReplicaClient> getAvailableClients(String originEndpoint, Boolean useCurrent) {
        return CONNECTIONS.get(originEndpoint).getAvailableClients(useCurrent);
    }

    void backoffClient(String originEndpoint, String endpoint) {
        CONNECTIONS.get(originEndpoint).backoffClient(endpoint);
    }

    Map<String, AppConfigurationStoreHealth> getHealth() {
        HashMap<String, AppConfigurationStoreHealth> health = new HashMap<String, AppConfigurationStoreHealth>();
        CONNECTIONS.forEach((key, value) -> health.put((String)key, value.getHealth()));
        return health;
    }

    String findOriginForEndpoint(String endpoint) {
        for (ConfigStore store : this.configStores) {
            List<String> replicas = store.getEndpoints();
            if (replicas == null || !replicas.contains(endpoint)) continue;
            return store.getEndpoint();
        }
        return endpoint;
    }

    void setCurrentConfigStoreClient(String originEndpoint, String replicaEndpoint) {
        CONNECTIONS.get(originEndpoint).setCurrentClient(replicaEndpoint);
    }

    void updateSyncToken(String originEndpoint, String endpoint, String syncToken) {
        CONNECTIONS.get(originEndpoint).updateSyncToken(endpoint, syncToken);
    }
}

