/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import java.util.Random;

final class BackoffTimeCalculator {
    private static final long MAX_ATTEMPTS = 63L;
    private static final long SECONDS_TO_NANOSECONDS = 1000000000L;
    private static final Random RANDOM = new Random();
    private static long maxBackoffSeconds = 600L;
    private static long minBackoffSeconds = 30L;

    BackoffTimeCalculator() {
    }

    static void setDefaults(Long maxBackoff, Long minBackoff) {
        maxBackoffSeconds = maxBackoff != null ? maxBackoff : 600L;
        minBackoffSeconds = minBackoff != null ? minBackoff : 30L;
    }

    static long calculateBackoff(Integer attempts) {
        if (minBackoffSeconds < 0L) {
            throw new IllegalArgumentException("Minimum Backoff time needs to be greater than or equal to 0.");
        }
        if (maxBackoffSeconds < 0L) {
            throw new IllegalArgumentException("Maximum Backoff time needs to be greater than or equal to 0.");
        }
        if (attempts < 0) {
            throw new IllegalArgumentException("Number of previous attempts needs to be a positive number.");
        }
        long minBackoffNano = minBackoffSeconds * 1000000000L;
        long maxBackoffNano = maxBackoffSeconds * 1000000000L;
        if (attempts <= 1 || maxBackoffNano <= minBackoffNano) {
            return minBackoffNano;
        }
        double maxNanoSeconds = Math.max(1L, minBackoffNano) * (1L << (int)Math.min((long)attempts.intValue(), 63L));
        if (maxNanoSeconds > (double)maxBackoffNano || maxNanoSeconds <= 0.0) {
            maxNanoSeconds = maxBackoffNano;
        }
        return (long)((double)minBackoffNano + (RANDOM.nextDouble() * (maxNanoSeconds - (double)minBackoffNano) + (double)minBackoffNano));
    }
}

