/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.feature;

import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlags;
import java.time.Instant;
import java.util.List;

public class FeatureFlagState {
    private final List<FeatureFlags> watchKeys;
    private final Instant nextRefreshCheck;
    private final String originEndpoint;

    public FeatureFlagState(List<FeatureFlags> watchKeys, int refreshInterval, String originEndpoint) {
        this.watchKeys = watchKeys;
        this.nextRefreshCheck = Instant.now().plusSeconds(refreshInterval);
        this.originEndpoint = originEndpoint;
    }

    public FeatureFlagState(FeatureFlagState oldState, Instant newRefresh) {
        this.watchKeys = oldState.getWatchKeys();
        this.nextRefreshCheck = newRefresh;
        this.originEndpoint = oldState.getOriginEndpoint();
    }

    public List<FeatureFlags> getWatchKeys() {
        return this.watchKeys;
    }

    public Instant getNextRefreshCheck() {
        return this.nextRefreshCheck;
    }

    public String getOriginEndpoint() {
        return this.originEndpoint;
    }
}

