/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management;

import com.azure.spring.cloud.feature.management.FeatureManager;
import com.azure.spring.cloud.feature.management.filters.PercentageFilter;
import com.azure.spring.cloud.feature.management.filters.TargetingFilter;
import com.azure.spring.cloud.feature.management.filters.TimeWindowFilter;
import com.azure.spring.cloud.feature.management.implementation.FeatureManagementConfigProperties;
import com.azure.spring.cloud.feature.management.implementation.FeatureManagementProperties;
import com.azure.spring.cloud.feature.management.targeting.TargetingContextAccessor;
import com.azure.spring.cloud.feature.management.targeting.TargetingEvaluationOptions;
import com.azure.spring.cloud.feature.management.telemetry.LoggerTelemetryPublisher;
import com.azure.spring.cloud.feature.management.telemetry.TelemetryPublisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.lang.NonNull;

@Configuration
@EnableConfigurationProperties(value={FeatureManagementConfigProperties.class, FeatureManagementProperties.class})
class FeatureManagementConfiguration
implements ApplicationContextAware {
    private ApplicationContext appContext;

    FeatureManagementConfiguration() {
    }

    @Bean
    FeatureManager featureManager(FeatureManagementProperties featureManagementConfigurations, FeatureManagementConfigProperties properties, TelemetryPublisher telemetryPublisher, ObjectProvider<TargetingContextAccessor> contextAccessorProvider, ObjectProvider<TargetingEvaluationOptions> evaluationOptionsProvider) {
        TargetingContextAccessor contextAccessor = (TargetingContextAccessor)contextAccessorProvider.getIfAvailable();
        TargetingEvaluationOptions evaluationOptions = (TargetingEvaluationOptions)evaluationOptionsProvider.getIfAvailable(() -> new TargetingEvaluationOptions());
        return new FeatureManager(this.appContext, featureManagementConfigurations, properties, contextAccessor, evaluationOptions, telemetryPublisher);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    @Bean(name={"Microsoft.TimeWindow"})
    @ConditionalOnMissingBean(value={TimeWindowFilter.class})
    public TimeWindowFilter timeWindowFilter() {
        return new TimeWindowFilter();
    }

    @Bean(name={"Microsoft.Percentage"})
    @ConditionalOnMissingBean(value={PercentageFilter.class})
    public PercentageFilter percentageFilter() {
        return new PercentageFilter();
    }

    @Bean(name={"Microsoft.Targeting"})
    @Scope(value="request")
    @ConditionalOnMissingBean(value={TargetingFilter.class})
    @ConditionalOnBean(value={TargetingContextAccessor.class})
    public TargetingFilter targetingFilter(TargetingContextAccessor context, ObjectProvider<TargetingEvaluationOptions> evaluationOptionsProvider) {
        TargetingEvaluationOptions evaluationOptions = (TargetingEvaluationOptions)evaluationOptionsProvider.getIfAvailable(() -> new TargetingEvaluationOptions().setIgnoreCase(true));
        return new TargetingFilter(context, evaluationOptions);
    }

    @Bean
    @ConditionalOnMissingBean(value={TelemetryPublisher.class})
    public TelemetryPublisher telemetryPublisher() {
        return new LoggerTelemetryPublisher();
    }
}

