/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.filters;

import com.azure.spring.cloud.feature.management.filters.FeatureFilter;
import com.azure.spring.cloud.feature.management.implementation.FeatureFilterUtils;
import com.azure.spring.cloud.feature.management.implementation.timewindow.TimeWindowFilterSettings;
import com.azure.spring.cloud.feature.management.implementation.timewindow.recurrence.RecurrenceEvaluator;
import com.azure.spring.cloud.feature.management.models.FeatureFilterEvaluationContext;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.time.ZonedDateTime;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeWindowFilter
implements FeatureFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeWindowFilter.class);
    private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();

    @Override
    public boolean evaluate(FeatureFilterEvaluationContext context) {
        Map recurrenceParameters;
        Object patternObj;
        Map<String, Object> parameters = context.getParameters();
        Object recurrenceObject = parameters.get(FeatureFilterUtils.getKeyCase(parameters, "Recurrence"));
        if (recurrenceObject != null && (patternObj = (recurrenceParameters = (Map)recurrenceObject).get(FeatureFilterUtils.getKeyCase(recurrenceParameters, "Pattern"))) != null) {
            FeatureFilterUtils.updateValueFromMapToList((Map)patternObj, FeatureFilterUtils.getKeyCase((Map)patternObj, "DaysOfWeek"));
        }
        TimeWindowFilterSettings settings = (TimeWindowFilterSettings)OBJECT_MAPPER.convertValue(context.getParameters(), TimeWindowFilterSettings.class);
        ZonedDateTime now = ZonedDateTime.now();
        if (settings.getStart() == null && settings.getEnd() == null) {
            LOGGER.warn("The {} feature filter is not valid for feature {}. It must specify either {}, {}, or both.", new Object[]{this.getClass().getSimpleName(), context.getName(), "Start", "End"});
            return false;
        }
        if (settings.getRecurrence() != null) {
            if (settings.getStart() != null && settings.getEnd() != null) {
                try {
                    return RecurrenceEvaluator.isMatch(settings, now);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("The {} feature filter is not valid for feature {}. {}", new Object[]{this.getClass().getSimpleName(), context.getName(), e.getMessage()});
                    throw e;
                }
            }
            LOGGER.warn("The {} feature filter is not valid for feature {}. It must specify both {} and {} when Recurrence is not null.", new Object[]{this.getClass().getSimpleName(), context.getName(), "Start", "End"});
            return false;
        }
        return !(settings.getStart() != null && !now.isAfter(settings.getStart()) || settings.getEnd() != null && !now.isBefore(settings.getEnd()));
    }
}

