/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation.models;

import com.azure.spring.cloud.feature.management.implementation.models.RecurrencePatternType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RecurrencePattern {
    private RecurrencePatternType type = RecurrencePatternType.DAILY;
    private Integer interval = 1;
    private List<DayOfWeek> daysOfWeek = new ArrayList<DayOfWeek>();
    private DayOfWeek firstDayOfWeek = DayOfWeek.SUNDAY;

    public RecurrencePatternType getType() {
        return this.type;
    }

    public RecurrencePattern setType(String type) throws IllegalArgumentException {
        try {
            this.type = RecurrencePatternType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("The value of parameter %s should be one of [%s].", "Recurrence.Pattern.Type", Arrays.toString((Object[])RecurrencePatternType.values())));
        }
        return this;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public RecurrencePattern setInterval(Integer interval) throws IllegalArgumentException {
        if (interval == null || interval <= 0) {
            throw new IllegalArgumentException(String.format("The value of parameter %s is out of the accepted range.", "Recurrence.Pattern.Interval"));
        }
        this.interval = interval;
        return this;
    }

    public List<DayOfWeek> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public RecurrencePattern setDaysOfWeek(List<String> daysOfWeek) throws IllegalArgumentException {
        if (daysOfWeek == null || daysOfWeek.size() == 0) {
            throw new IllegalArgumentException(String.format("Value cannot be null for required parameter: %s", "Recurrence.Pattern.DaysOfWeek"));
        }
        try {
            for (String dayOfWeek : daysOfWeek) {
                this.daysOfWeek.add(DayOfWeek.valueOf(dayOfWeek.toUpperCase()));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("The value of parameter %s should be one of [%s].", "Recurrence.Pattern.DaysOfWeek", Arrays.toString(DayOfWeek.values())));
        }
        return this;
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public RecurrencePattern setFirstDayOfWeek(String firstDayOfWeek) throws IllegalArgumentException {
        if (firstDayOfWeek == null) {
            throw new IllegalArgumentException(String.format("Value cannot be null for required parameter: %s", "Recurrence.Pattern.FirstDayOfWeek"));
        }
        try {
            this.firstDayOfWeek = DayOfWeek.valueOf(firstDayOfWeek.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("The value of parameter %s should be one of [%s].", "Recurrence.Pattern.FirstDayOfWeek", Arrays.toString(DayOfWeek.values())));
        }
        return this;
    }
}

