/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation.timewindow;

import java.time.DayOfWeek;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.util.StringUtils;

public class TimeWindowUtils {
    public static ZonedDateTime convertStringToDate(String timeStr) {
        if (!StringUtils.hasText((String)timeStr)) {
            return null;
        }
        try {
            return ZonedDateTime.parse(timeStr, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            return ZonedDateTime.parse(timeStr, DateTimeFormatter.RFC_1123_DATE_TIME);
        }
    }

    public static int getPassedWeekDays(DayOfWeek today, DayOfWeek firstDayOfWeek) {
        return (today.getValue() - firstDayOfWeek.getValue() + 7) % 7;
    }

    public static List<DayOfWeek> sortDaysOfWeek(List<DayOfWeek> daysOfWeek, DayOfWeek firstDayOfWeek) {
        ArrayList<DayOfWeek> result = new ArrayList<DayOfWeek>(daysOfWeek);
        Collections.sort(result, Comparator.comparingInt(a -> TimeWindowUtils.getPassedWeekDays(a, firstDayOfWeek)));
        return result;
    }
}

