/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.servicebus.factory;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.service.implementation.servicebus.factory.AbstractServiceBusSubClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusReceiverClientProperties;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import org.springframework.util.Assert;

public class ServiceBusReceiverClientBuilderFactory
extends AbstractServiceBusSubClientBuilderFactory<ServiceBusClientBuilder.ServiceBusReceiverClientBuilder, ServiceBusReceiverClientProperties> {
    private final ServiceBusReceiverClientProperties receiverClientProperties;

    public ServiceBusReceiverClientBuilderFactory(ServiceBusReceiverClientProperties properties) {
        this((ServiceBusClientBuilder)null, properties);
    }

    public ServiceBusReceiverClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, ServiceBusReceiverClientProperties properties) {
        super(serviceBusClientBuilder, properties);
        this.receiverClientProperties = properties;
    }

    protected ServiceBusClientBuilder.ServiceBusReceiverClientBuilder createBuilderInstance() {
        return this.getServiceBusClientBuilder().receiver();
    }

    @Override
    protected void configureService(ServiceBusClientBuilder.ServiceBusReceiverClientBuilder builder) {
        Assert.notNull((Object)((Object)this.receiverClientProperties.getEntityType()), (String)"Entity type cannot be null.");
        Assert.notNull((Object)this.receiverClientProperties.getEntityName(), (String)"Entity name cannot be null.");
        super.configureService(builder);
        if (ServiceBusEntityType.TOPIC == this.receiverClientProperties.getEntityType()) {
            Assert.notNull((Object)this.receiverClientProperties.getSubscriptionName(), (String)"Subscription cannot be null.");
        }
        PropertyMapper propertyMapper = new PropertyMapper();
        if (ServiceBusEntityType.QUEUE == this.receiverClientProperties.getEntityType()) {
            propertyMapper.from((Object)this.receiverClientProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builder).queueName(arg_0));
        } else if (ServiceBusEntityType.TOPIC == this.receiverClientProperties.getEntityType()) {
            propertyMapper.from((Object)this.receiverClientProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builder).topicName(arg_0));
            propertyMapper.from((Object)this.receiverClientProperties.getSubscriptionName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builder).subscriptionName(arg_0));
        }
        propertyMapper.from((Object)this.receiverClientProperties.getReceiveMode()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builder).receiveMode(arg_0));
        propertyMapper.from((Object)this.receiverClientProperties.getSubQueue()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builder).subQueue(arg_0));
        propertyMapper.from((Object)this.receiverClientProperties.getPrefetchCount()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builder).prefetchCount(arg_0));
        propertyMapper.from((Object)this.receiverClientProperties.getMaxAutoLockRenewDuration()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builder).maxAutoLockRenewDuration(arg_0));
        propertyMapper.from((Object)this.receiverClientProperties.getAutoComplete()).whenFalse().to(t -> builder.disableAutoComplete());
    }
}

