/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.IJsonObject;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.Knot;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0006J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0007J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0016\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0003J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00062\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/github/erosb/jsonsKema/LoadingState;", "", "documentRoot", "Lcom/github/erosb/jsonsKema/IJsonValue;", "anchors", "", "", "Lcom/github/erosb/jsonsKema/Knot;", "baseURI", "Ljava/net/URI;", "(Lcom/github/erosb/jsonsKema/IJsonValue;Ljava/util/Map;Ljava/net/URI;)V", "getBaseURI", "()Ljava/net/URI;", "setBaseURI", "(Ljava/net/URI;)V", "getDocumentRoot", "()Lcom/github/erosb/jsonsKema/IJsonValue;", "anchorByURI", "ref", "component1", "component2", "component3", "copy", "equals", "", "other", "getAnchorByURI", "uri", "hashCode", "", "nextLoadableAnchor", "nextUnresolvedAnchor", "normalizeUri", "registerRawSchemaByAnchor", "id", "json", "registerRawSchemaByDynAnchor", "", "dynAnchor", "Lcom/github/erosb/jsonsKema/IJsonObject;", "toString", "json-sKema"})
public final class LoadingState {
    @NotNull
    private final IJsonValue documentRoot;
    @NotNull
    private final Map<String, Knot> anchors;
    @NotNull
    private URI baseURI;

    public LoadingState(@NotNull IJsonValue documentRoot, @NotNull Map<String, Knot> anchors, @NotNull URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)documentRoot, (String)"documentRoot");
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        Intrinsics.checkNotNullParameter((Object)baseURI, (String)"baseURI");
        this.documentRoot = documentRoot;
        this.anchors = anchors;
        this.baseURI = baseURI;
    }

    public /* synthetic */ LoadingState(IJsonValue iJsonValue, Map map, URI uRI, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        this(iJsonValue, map, uRI);
    }

    @NotNull
    public final IJsonValue getDocumentRoot() {
        return this.documentRoot;
    }

    @NotNull
    public final URI getBaseURI() {
        return this.baseURI;
    }

    public final void setBaseURI(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<set-?>");
        this.baseURI = uRI;
    }

    @NotNull
    public final Knot registerRawSchemaByAnchor(@NotNull String id, @NotNull IJsonValue json) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Knot anchor = this.getAnchorByURI(id);
        if (anchor.getJson() != null && anchor.getJson() != json) {
            throw new IllegalStateException("raw schema already registered by URI " + id);
        }
        anchor.setJson(json);
        return anchor;
    }

    @Nullable
    public final Knot nextLoadableAnchor() {
        Object v0;
        block1: {
            Iterable iterable = this.anchors.values();
            for (Object t : iterable) {
                Knot it = (Knot)t;
                boolean bl = false;
                if (!it.isLoadable()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Knot nextUnresolvedAnchor() {
        Object v0;
        block1: {
            Iterable iterable = this.anchors.values();
            for (Object t : iterable) {
                Knot it = (Knot)t;
                boolean bl = false;
                if (!(it.getJson() == null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Knot getAnchorByURI(@NotNull String uri) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Map<String, Knot> map = this.anchors;
        String key$iv = this.normalizeUri(uri);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Knot answer$iv = new Knot(null, new URI(uri), null, false, null, false, 61, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Knot)object;
    }

    @Nullable
    public final Knot anchorByURI(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this.anchors.get(this.normalizeUri(ref));
    }

    private final String normalizeUri(String uri) {
        String string;
        String effectiveUri = null;
        if (StringsKt.startsWith$default((String)uri, (String)"file:/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)uri, (String)"file:///", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append("file:///");
            String string2 = uri.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            effectiveUri = stringBuilder.append(string2).toString();
        } else {
            effectiveUri = uri;
        }
        if (StringsKt.endsWith$default((String)effectiveUri, (String)"#", (boolean)false, (int)2, null)) {
            String string3 = effectiveUri.substring(0, effectiveUri.length() - 1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = effectiveUri;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void registerRawSchemaByDynAnchor(@NotNull String dynAnchor, @NotNull IJsonObject<?, ?> json) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)dynAnchor, (String)"dynAnchor");
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Map<String, Knot> map = this.anchors;
        String key$iv = this.normalizeUri(dynAnchor);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Knot answer$iv = new Knot(null, null, null, false, null, true, 31, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Knot)object).setJson(json);
    }

    @NotNull
    public final IJsonValue component1() {
        return this.documentRoot;
    }

    private final Map<String, Knot> component2() {
        return this.anchors;
    }

    @NotNull
    public final URI component3() {
        return this.baseURI;
    }

    @NotNull
    public final LoadingState copy(@NotNull IJsonValue documentRoot, @NotNull Map<String, Knot> anchors, @NotNull URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)documentRoot, (String)"documentRoot");
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        Intrinsics.checkNotNullParameter((Object)baseURI, (String)"baseURI");
        return new LoadingState(documentRoot, anchors, baseURI);
    }

    public static /* synthetic */ LoadingState copy$default(LoadingState loadingState, IJsonValue iJsonValue, Map map, URI uRI, int n, Object object) {
        if ((n & 1) != 0) {
            iJsonValue = loadingState.documentRoot;
        }
        if ((n & 2) != 0) {
            map = loadingState.anchors;
        }
        if ((n & 4) != 0) {
            uRI = loadingState.baseURI;
        }
        return loadingState.copy(iJsonValue, map, uRI);
    }

    @NotNull
    public String toString() {
        return "LoadingState(documentRoot=" + this.documentRoot + ", anchors=" + this.anchors + ", baseURI=" + this.baseURI + ')';
    }

    public int hashCode() {
        int result = this.documentRoot.hashCode();
        result = result * 31 + ((Object)this.anchors).hashCode();
        result = result * 31 + this.baseURI.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LoadingState)) {
            return false;
        }
        LoadingState loadingState = (LoadingState)other;
        if (!Intrinsics.areEqual((Object)this.documentRoot, (Object)loadingState.documentRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.anchors, loadingState.anchors)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.baseURI, (Object)loadingState.baseURI);
    }
}

