/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SnapshotId
extends ResourceId {
    private static final String REGEX = ".*?projects/([^/]+)/global/snapshots/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/global/snapshots/([^/]+)");
    private static final long serialVersionUID = -1699492866663041082L;
    private final String snapshot;

    private SnapshotId(String project, String snapshot) {
        super(project);
        this.snapshot = (String)Preconditions.checkNotNull((Object)snapshot);
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/global/snapshots/" + this.snapshot;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("snapshot", (Object)this.snapshot);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.snapshot);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SnapshotId)) {
            return false;
        }
        SnapshotId other = (SnapshotId)obj;
        return this.baseEquals(other) && Objects.equals(this.snapshot, other.snapshot);
    }

    @Override
    SnapshotId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return SnapshotId.of(projectId, this.snapshot);
    }

    public static SnapshotId of(String snapshot) {
        return new SnapshotId(null, snapshot);
    }

    public static SnapshotId of(String project, String snapshot) {
        return new SnapshotId(project, snapshot);
    }

    static boolean matchesUrl(String url) {
        return url.matches(REGEX);
    }

    static SnapshotId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid snapshot URL");
        }
        return SnapshotId.of(matcher.group(1), matcher.group(2));
    }
}

