/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns.spi.v1;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.dns.Dns;
import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ChangesListResponse;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.ManagedZonesListResponse;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.ResourceRecordSet;
import com.google.api.services.dns.model.ResourceRecordSetsListResponse;
import com.google.cloud.ServiceOptions;
import com.google.cloud.dns.DnsException;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.spi.v1.DnsRpc;
import com.google.cloud.dns.spi.v1.RpcBatch;
import com.google.cloud.http.HttpTransportOptions;
import java.io.IOException;
import java.util.Map;

public class HttpDnsRpc
implements DnsRpc {
    private static final String SORT_BY = "changeSequence";
    private final Dns dns;
    private final DnsOptions options;

    private static <T> JsonBatchCallback<T> toJsonCallback(final RpcBatch.Callback<T> callback) {
        return new JsonBatchCallback<T>(){

            public void onSuccess(T response, HttpHeaders httpHeaders) throws IOException {
                callback.onSuccess(response);
            }

            public void onFailure(GoogleJsonError googleJsonError, HttpHeaders httpHeaders) throws IOException {
                callback.onFailure(googleJsonError);
            }
        };
    }

    private static DnsException translate(IOException exception, boolean idempotent) {
        return new DnsException(exception, idempotent);
    }

    public HttpDnsRpc(DnsOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer((ServiceOptions)options);
        this.dns = new Dns.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.getHost()).setApplicationName(options.getApplicationName()).build();
        this.options = options;
    }

    @Override
    public ManagedZone create(ManagedZone zone, Map<DnsRpc.Option, ?> options) throws DnsException {
        try {
            return (ManagedZone)this.createZoneCall(zone, options).execute();
        }
        catch (IOException ex) {
            throw HttpDnsRpc.translate(ex, true);
        }
    }

    private Dns.ManagedZones.Create createZoneCall(ManagedZone zone, Map<DnsRpc.Option, ?> options) throws IOException {
        return this.dns.managedZones().create(this.options.getProjectId(), zone).setFields(DnsRpc.Option.FIELDS.getString(options));
    }

    @Override
    public ManagedZone getZone(String zoneName, Map<DnsRpc.Option, ?> options) throws DnsException {
        try {
            return (ManagedZone)this.getZoneCall(zoneName, options).execute();
        }
        catch (IOException ex) {
            DnsException serviceException = HttpDnsRpc.translate(ex, true);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    private Dns.ManagedZones.Get getZoneCall(String zoneName, Map<DnsRpc.Option, ?> options) throws IOException {
        return this.dns.managedZones().get(this.options.getProjectId(), zoneName).setFields(DnsRpc.Option.FIELDS.getString(options));
    }

    @Override
    public DnsRpc.ListResult<ManagedZone> listZones(Map<DnsRpc.Option, ?> options) throws DnsException {
        try {
            ManagedZonesListResponse zoneList = (ManagedZonesListResponse)this.listZonesCall(options).execute();
            return DnsRpc.ListResult.of(zoneList.getNextPageToken(), zoneList.getManagedZones());
        }
        catch (IOException ex) {
            throw HttpDnsRpc.translate(ex, true);
        }
    }

    private Dns.ManagedZones.List listZonesCall(Map<DnsRpc.Option, ?> options) throws IOException {
        return this.dns.managedZones().list(this.options.getProjectId()).setFields(DnsRpc.Option.FIELDS.getString(options)).setMaxResults(DnsRpc.Option.PAGE_SIZE.getInt(options)).setDnsName(DnsRpc.Option.DNS_NAME.getString(options)).setPageToken(DnsRpc.Option.PAGE_TOKEN.getString(options));
    }

    @Override
    public boolean deleteZone(String zoneName) throws DnsException {
        try {
            this.deleteZoneCall(zoneName).execute();
            return true;
        }
        catch (IOException ex) {
            DnsException serviceException = HttpDnsRpc.translate(ex, false);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    private Dns.ManagedZones.Delete deleteZoneCall(String zoneName) throws IOException {
        return this.dns.managedZones().delete(this.options.getProjectId(), zoneName);
    }

    @Override
    public DnsRpc.ListResult<ResourceRecordSet> listRecordSets(String zoneName, Map<DnsRpc.Option, ?> options) throws DnsException {
        try {
            ResourceRecordSetsListResponse response = (ResourceRecordSetsListResponse)this.listRecordSetsCall(zoneName, options).execute();
            return DnsRpc.ListResult.of(response.getNextPageToken(), response.getRrsets());
        }
        catch (IOException ex) {
            throw HttpDnsRpc.translate(ex, true);
        }
    }

    private Dns.ResourceRecordSets.List listRecordSetsCall(String zoneName, Map<DnsRpc.Option, ?> options) throws IOException {
        return this.dns.resourceRecordSets().list(this.options.getProjectId(), zoneName).setFields(DnsRpc.Option.FIELDS.getString(options)).setPageToken(DnsRpc.Option.PAGE_TOKEN.getString(options)).setMaxResults(DnsRpc.Option.PAGE_SIZE.getInt(options)).setName(DnsRpc.Option.NAME.getString(options)).setType(DnsRpc.Option.DNS_TYPE.getString(options));
    }

    @Override
    public Project getProject(Map<DnsRpc.Option, ?> options) throws DnsException {
        try {
            return (Project)this.getProjectCall(options).execute();
        }
        catch (IOException ex) {
            throw HttpDnsRpc.translate(ex, true);
        }
    }

    private Dns.Projects.Get getProjectCall(Map<DnsRpc.Option, ?> options) throws IOException {
        return this.dns.projects().get(this.options.getProjectId()).setFields(DnsRpc.Option.FIELDS.getString(options));
    }

    @Override
    public Change applyChangeRequest(String zoneName, Change changeRequest, Map<DnsRpc.Option, ?> options) throws DnsException {
        try {
            return (Change)this.applyChangeRequestCall(zoneName, changeRequest, options).execute();
        }
        catch (IOException ex) {
            throw HttpDnsRpc.translate(ex, false);
        }
    }

    private Dns.Changes.Create applyChangeRequestCall(String zoneName, Change changeRequest, Map<DnsRpc.Option, ?> options) throws IOException {
        return this.dns.changes().create(this.options.getProjectId(), zoneName, changeRequest).setFields(DnsRpc.Option.FIELDS.getString(options));
    }

    @Override
    public Change getChangeRequest(String zoneName, String changeRequestId, Map<DnsRpc.Option, ?> options) throws DnsException {
        try {
            return (Change)this.getChangeRequestCall(zoneName, changeRequestId, options).execute();
        }
        catch (IOException ex) {
            DnsException serviceException = HttpDnsRpc.translate(ex, true);
            if (serviceException.getCode() == 404 && ("entity.parameters.changeId".equals(serviceException.getLocation()) || serviceException.getMessage() != null && serviceException.getMessage().contains("parameters.changeId"))) {
                return null;
            }
            throw serviceException;
        }
    }

    private Dns.Changes.Get getChangeRequestCall(String zoneName, String changeRequestId, Map<DnsRpc.Option, ?> options) throws IOException {
        return this.dns.changes().get(this.options.getProjectId(), zoneName, changeRequestId).setFields(DnsRpc.Option.FIELDS.getString(options));
    }

    @Override
    public DnsRpc.ListResult<Change> listChangeRequests(String zoneName, Map<DnsRpc.Option, ?> options) throws DnsException {
        try {
            ChangesListResponse response = (ChangesListResponse)this.listChangeRequestsCall(zoneName, options).execute();
            return DnsRpc.ListResult.of(response.getNextPageToken(), response.getChanges());
        }
        catch (IOException ex) {
            throw HttpDnsRpc.translate(ex, true);
        }
    }

    private Dns.Changes.List listChangeRequestsCall(String zoneName, Map<DnsRpc.Option, ?> options) throws IOException {
        Dns.Changes.List request = this.dns.changes().list(this.options.getProjectId(), zoneName).setFields(DnsRpc.Option.FIELDS.getString(options)).setMaxResults(DnsRpc.Option.PAGE_SIZE.getInt(options)).setPageToken(DnsRpc.Option.PAGE_TOKEN.getString(options));
        if (DnsRpc.Option.SORTING_ORDER.getString(options) != null) {
            request = request.setSortBy(SORT_BY).setSortOrder(DnsRpc.Option.SORTING_ORDER.getString(options));
        }
        return request;
    }

    @Override
    public RpcBatch createBatch() {
        return new DefaultRpcBatch(this.dns.batch());
    }

    private class DefaultRpcBatch
    implements RpcBatch {
        private final BatchRequest batch;

        private DefaultRpcBatch(BatchRequest batch) {
            this.batch = batch;
        }

        @Override
        public void addListZones(RpcBatch.Callback<ManagedZonesListResponse> callback, Map<DnsRpc.Option, ?> options) {
            try {
                HttpDnsRpc.this.listZonesCall(options).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void addCreateZone(ManagedZone zone, RpcBatch.Callback<ManagedZone> callback, Map<DnsRpc.Option, ?> options) {
            try {
                HttpDnsRpc.this.createZoneCall(zone, options).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void addGetZone(String zoneName, RpcBatch.Callback<ManagedZone> callback, Map<DnsRpc.Option, ?> options) {
            try {
                HttpDnsRpc.this.getZoneCall(zoneName, options).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void addDeleteZone(String zoneName, RpcBatch.Callback<Void> callback) {
            try {
                HttpDnsRpc.this.deleteZoneCall(zoneName).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void addGetProject(RpcBatch.Callback<Project> callback, Map<DnsRpc.Option, ?> options) {
            try {
                HttpDnsRpc.this.getProjectCall(options).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void addListRecordSets(String zoneName, RpcBatch.Callback<ResourceRecordSetsListResponse> callback, Map<DnsRpc.Option, ?> options) {
            try {
                HttpDnsRpc.this.listRecordSetsCall(zoneName, options).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void addListChangeRequests(String zoneName, RpcBatch.Callback<ChangesListResponse> callback, Map<DnsRpc.Option, ?> options) {
            try {
                HttpDnsRpc.this.listChangeRequestsCall(zoneName, options).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void addGetChangeRequest(String zoneName, String changeRequestId, RpcBatch.Callback<Change> callback, Map<DnsRpc.Option, ?> options) {
            try {
                HttpDnsRpc.this.getChangeRequestCall(zoneName, changeRequestId, options).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void addApplyChangeRequest(String zoneName, Change change, RpcBatch.Callback<Change> callback, Map<DnsRpc.Option, ?> options) {
            try {
                HttpDnsRpc.this.applyChangeRequestCall(zoneName, change, options).queue(this.batch, HttpDnsRpc.toJsonCallback(callback));
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }

        @Override
        public void submit() {
            try {
                this.batch.execute();
            }
            catch (IOException ex) {
                throw HttpDnsRpc.translate(ex, false);
            }
        }
    }
}

