/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.HttpStatusLine;
import com.microsoft.azure.proton.transport.proxy.ProxyResponse;
import com.microsoft.azure.proton.transport.proxy.impl.StringUtils;
import com.microsoft.azure.proton.transport.ws.WebSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyResponseImpl
implements ProxyResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyResponseImpl.class);
    private final HttpStatusLine status;
    private final Map<String, List<String>> headers;
    private final ByteBuffer contents;

    private ProxyResponseImpl(HttpStatusLine status, Map<String, List<String>> headers, ByteBuffer contents) {
        this.status = status;
        this.headers = headers;
        this.contents = contents;
    }

    public static ProxyResponse create(ByteBuffer buffer) {
        int size = buffer.remaining();
        if (size <= 0) {
            throw new IllegalArgumentException(String.format("Cannot create response with buffer have no content. Limit: %s. Position: %s. Cap: %s", buffer.limit(), buffer.position(), buffer.capacity()));
        }
        byte[] responseBytes = new byte[size];
        buffer.get(responseBytes);
        String response = new String(responseBytes, StandardCharsets.UTF_8);
        String[] lines = response.split("\r\n");
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        WebSocket.WebSocketFrameReadState frameReadState = WebSocket.WebSocketFrameReadState.INIT_READ;
        HttpStatusLine statusLine = null;
        ByteBuffer contents = ByteBuffer.allocate(0);
        block6: for (String line : lines) {
            switch (frameReadState) {
                case INIT_READ: {
                    statusLine = HttpStatusLine.create(line);
                    frameReadState = WebSocket.WebSocketFrameReadState.CHUNK_READ;
                    continue block6;
                }
                case CHUNK_READ: {
                    if (StringUtils.isNullOrEmpty(line)) {
                        boolean hasBody;
                        int length = 0;
                        if (headers.containsKey("Content-Length")) {
                            List contentLength = (List)headers.get("Content-Length");
                            length = Integer.parseInt((String)contentLength.get(0));
                        }
                        boolean bl = hasBody = length > 0;
                        if (!hasBody) {
                            LOGGER.info("There is no content in the response. Response: {}", (Object)response);
                            return new ProxyResponseImpl(statusLine, headers, contents);
                        }
                        contents = ByteBuffer.allocate(length);
                        frameReadState = WebSocket.WebSocketFrameReadState.HEADER_READ;
                        continue block6;
                    }
                    Map.Entry<String, String> header = ProxyResponseImpl.parseHeader(line);
                    List value = headers.getOrDefault(header.getKey(), new ArrayList());
                    value.add(header.getValue());
                    headers.put(header.getKey(), value);
                    continue block6;
                }
                case HEADER_READ: {
                    if (contents.position() == 0) {
                        frameReadState = WebSocket.WebSocketFrameReadState.CONTINUED_FRAME_READ;
                    }
                    contents.put(line.getBytes(StandardCharsets.UTF_8));
                    contents.mark();
                    continue block6;
                }
                case CONTINUED_FRAME_READ: {
                    contents.put(line.getBytes(StandardCharsets.UTF_8));
                    contents.mark();
                    continue block6;
                }
                default: {
                    LOGGER.error("Unknown state: {}. Response: {}", (Object)frameReadState, (Object)response);
                    frameReadState = WebSocket.WebSocketFrameReadState.READ_ERROR;
                }
            }
        }
        return new ProxyResponseImpl(statusLine, headers, contents);
    }

    private static Map.Entry<String, String> parseHeader(String contents) {
        String[] split = contents.split(":", 2);
        if (split.length != 2) {
            throw new IllegalStateException("Line is not a valid header. Contents: " + contents);
        }
        return new AbstractMap.SimpleEntry<String, String>(split[0].trim(), split[1].trim());
    }

    @Override
    public HttpStatusLine getStatus() {
        return this.status;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public ByteBuffer getContents() {
        return this.contents.duplicate();
    }

    @Override
    public String getError() {
        ByteBuffer readonly = this.contents.asReadOnlyBuffer();
        readonly.flip();
        return StandardCharsets.UTF_8.decode(readonly).toString();
    }

    @Override
    public boolean isMissingContent() {
        return this.contents.hasRemaining();
    }

    @Override
    public void addContent(ByteBuffer content) {
        Objects.requireNonNull(content, "'content' cannot be null.");
        int size = content.remaining();
        if (size <= 0) {
            throw new IllegalArgumentException("There was no content to add to current HTTP response.");
        }
        byte[] responseBytes = new byte[content.remaining()];
        content.get(responseBytes);
        this.contents.put(responseBytes);
    }

    @Override
    public boolean hasConnectionCloseHeader() {
        List<String> connectionHeaders;
        String headerKey;
        String string = headerKey = this.headers.containsKey("Connection") ? "Connection" : "connection";
        if (this.headers.containsKey(headerKey) && (connectionHeaders = this.headers.get(headerKey)) != null && !connectionHeaders.isEmpty()) {
            for (String header : connectionHeaders) {
                if (!header.equalsIgnoreCase("close")) continue;
                return true;
            }
        }
        return false;
    }
}

