/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HANonceManager
extends NonceManager {
    private Long maxNonceAge;
    private BackingStore<String, HAPojo> backingStore = null;
    private final ScheduledExecutorService singleThreadScheduledExecutor = Executors.newSingleThreadScheduledExecutor();

    public HANonceManager(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
        try {
            BackingStoreConfiguration<String, HAPojo> bsConfig = HighAvailabilityProvider.INSTANCE.initBackingStoreConfiguration("HANonceManagerStore", String.class, HAPojo.class);
            bsConfig.getVendorSpecificSettings().put("max.idle.timeout.in.seconds", maxNonceAge / 1000L);
            bsConfig.setClassLoader(ClassLoader.getSystemClassLoader());
            bsConfig.getVendorSpecificSettings().put("start.gms", true);
            BackingStoreFactory bsFactory = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
            this.backingStore = bsFactory.createBackingStore(bsConfig);
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        this.singleThreadScheduledExecutor.scheduleAtFixedRate(new nonceCleanupTask(), maxNonceAge, maxNonceAge, TimeUnit.MILLISECONDS);
    }

    public HANonceManager(BackingStore<String, HAPojo> backingStore, long maxNonceAge) {
        this.backingStore = backingStore;
        this.maxNonceAge = maxNonceAge;
        this.singleThreadScheduledExecutor.scheduleAtFixedRate(new nonceCleanupTask(), maxNonceAge, maxNonceAge, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean validateNonce(String nonce, String created) throws NonceManager.NonceException {
        byte[] data = created.getBytes();
        HAPojo pojo = new HAPojo();
        pojo.setData(data);
        try {
            HAPojo value = null;
            try {
                value = HighAvailabilityProvider.loadFrom(this.backingStore, nonce, null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, " exception during load command ");
            }
            if (value != null) {
                String message = "Nonce Repeated : Nonce Cache already contains the nonce value :" + nonce;
                LOGGER.log(Level.WARNING, LogStringsMessages.WSS_0815_NONCE_REPEATED_ERROR(nonce));
                throw new NonceManager.NonceException(message);
            }
            HighAvailabilityProvider.saveTo(this.backingStore, nonce, pojo, true);
            LOGGER.log(Level.INFO, " nonce " + nonce + " saved ");
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public void remove(String key) throws BackingStoreException {
        this.backingStore.remove(key);
    }

    public static class HAPojo
    implements Serializable {
        byte[] data;

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public class nonceCleanupTask
    implements Runnable {
        public void run() {
            try {
                int removed = HANonceManager.this.backingStore.removeExpired(HANonceManager.this.maxNonceAge);
                System.out.println("removed no. of entries = " + removed);
            }
            catch (BackingStoreException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }
}

