/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.transform;

import com.sun.xml.wss.impl.transform.Canonicalizer20010315ExclOmitComments;
import com.sun.xml.wss.logging.impl.dsig.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class STRTransformImpl {
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");

    protected static Data transform(Data data, XMLCryptoContext context, OutputStream outputStream) throws TransformException {
        try {
            Set nodeSet = STRTransformImpl.getNodeSet(data);
            if (outputStream == null) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                new Canonicalizer20010315ExclOmitComments().engineCanonicalizeXPathNodeSet(nodeSet, "", bs, context);
                OctetStreamData osd = new OctetStreamData(new ByteArrayInputStream(bs.toByteArray()));
                bs.close();
                return osd;
            }
            new Canonicalizer20010315ExclOmitComments().engineCanonicalizeXPathNodeSet(nodeSet, "", outputStream, context);
            return null;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1322_STR_TRANSFORM(), ex);
            return null;
        }
    }

    private static Set getNodeSet(Data data) throws TransformException {
        HashSet nodeSet = new HashSet();
        if (data instanceof NodeSetData) {
            Iterator it = ((NodeSetData)data).iterator();
            while (it.hasNext()) {
                Object node = it.next();
                nodeSet.add(node);
            }
        } else if (data instanceof OctetStreamData) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                Document doc = factory.newDocumentBuilder().parse(((OctetStreamData)data).getOctetStream());
                STRTransformImpl.toNodeSet(doc, nodeSet);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1322_STR_TRANSFORM(), ex);
                throw new TransformException(ex.getMessage());
            }
        }
        return nodeSet;
    }

    static final void toNodeSet(Node rootNode, Set result) {
        if (rootNode == null) {
            return;
        }
        switch (rootNode.getNodeType()) {
            case 1: {
                result.add(rootNode);
                Element el = (Element)rootNode;
                if (el.hasAttributes()) {
                    NamedNodeMap nl = ((Element)rootNode).getAttributes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        result.add(nl.item(i));
                    }
                }
            }
            case 9: {
                for (Node r = rootNode.getFirstChild(); r != null; r = r.getNextSibling()) {
                    if (r.getNodeType() == 3) {
                        result.add(r);
                        while (r != null && r.getNodeType() == 3) {
                            r = r.getNextSibling();
                        }
                        if (r == null) {
                            return;
                        }
                    }
                    STRTransformImpl.toNodeSet(r, result);
                }
                return;
            }
            case 8: {
                return;
            }
            case 10: {
                return;
            }
        }
        result.add(rootNode);
    }
}

