/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.batch;

import java.util.Date;
import java.util.List;
import net.gencat.ctti.canigo.services.logging.Log;
import net.gencat.ctti.canigo.services.logging.log4j.Log4JServiceImpl;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.listener.CompositeExecutionJobListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class StoppableSimpleJob
extends AbstractJob {
    private JobRepository jobRepository;
    private CompositeExecutionJobListener listener = new CompositeExecutionJobListener();
    private PlatformTransactionManager transactionManager;
    private boolean transactional = false;
    private Log4JServiceImpl loggingService;
    private Log logger;

    public void setLoggingService(Log4JServiceImpl loggingService) {
        this.loggingService = loggingService;
        this.logger = this.loggingService.getLog(((Object)((Object)this)).getClass());
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setJobExecutionListeners(JobExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.listener.register(listeners[i]);
        }
    }

    public void registerJobExecutionListener(JobExecutionListener listener) {
        this.listener.register(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(JobExecution execution) throws JobExecutionException {
        TransactionStatus transaction;
        ExitStatus jobStatus;
        block26: {
            block29: {
                StepExecution currentStepExecution;
                block27: {
                    block28: {
                        JobInstance jobInstance = execution.getJobInstance();
                        currentStepExecution = null;
                        int startedCount = 0;
                        List steps = this.getSteps();
                        jobStatus = ExitStatus.UNKNOWN;
                        transaction = null;
                        if (this.isTransactional()) {
                            transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
                        }
                        try {
                            try {
                                if (execution.getStatus() == BatchStatus.STOPPING) {
                                    throw new JobInterruptedException("JobExecution already stopped before being executed.");
                                }
                                execution.setStartTime(new Date());
                                this.updateStatus(execution, BatchStatus.STARTING);
                                this.listener.beforeJob(execution);
                                for (Step step : steps) {
                                    if (!this.shouldStart(jobInstance, step)) continue;
                                    ++startedCount;
                                    this.updateStatus(execution, BatchStatus.STARTED);
                                    currentStepExecution = execution.createStepExecution(step);
                                    StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, step);
                                    boolean isRestart = false;
                                    if (this.jobRepository.getStepExecutionCount(jobInstance, step) > 0 && !lastStepExecution.getExitStatus().equals((Object)ExitStatus.FINISHED)) {
                                        isRestart = true;
                                    }
                                    if (isRestart && lastStepExecution != null) {
                                        currentStepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
                                    } else {
                                        currentStepExecution.setExecutionContext(new ExecutionContext());
                                    }
                                    step.execute(currentStepExecution);
                                    if (!currentStepExecution.isTerminateOnly()) continue;
                                }
                                this.updateStatus(execution, BatchStatus.COMPLETED);
                                this.listener.afterJob(execution);
                            }
                            catch (JobInterruptedException e) {
                                execution.setStatus(BatchStatus.STOPPED);
                                this.listener.onInterrupt(execution);
                                if (transaction != null) {
                                    this.transactionManager.rollback(transaction);
                                }
                                StoppableSimpleJob.rethrow(e);
                                Object var13_16 = null;
                                jobStatus = ExitStatus.FAILED;
                                if (startedCount == 0) {
                                    jobStatus = steps.size() > 0 ? ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.") : ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
                                } else if (currentStepExecution != null) {
                                    jobStatus = currentStepExecution.getExitStatus();
                                }
                                execution.setEndTime(new Date());
                                execution.setExitStatus(jobStatus);
                                this.jobRepository.saveOrUpdate(execution);
                                break block26;
                            }
                            catch (Throwable t) {
                                execution.setStatus(BatchStatus.FAILED);
                                this.listener.onError(execution, t);
                                if (transaction != null) {
                                    this.transactionManager.rollback(transaction);
                                }
                                StoppableSimpleJob.rethrow(t);
                                Object var13_17 = null;
                                jobStatus = ExitStatus.FAILED;
                                if (startedCount == 0) {
                                    jobStatus = steps.size() > 0 ? ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.") : ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
                                } else if (currentStepExecution != null) {
                                    jobStatus = currentStepExecution.getExitStatus();
                                }
                                execution.setEndTime(new Date());
                                execution.setExitStatus(jobStatus);
                                this.jobRepository.saveOrUpdate(execution);
                                break block26;
                            }
                            Object var13_15 = null;
                            jobStatus = ExitStatus.FAILED;
                            if (startedCount != 0) break block27;
                            if (steps.size() <= 0) break block28;
                        }
                        catch (Throwable throwable) {
                            Object var13_18 = null;
                            jobStatus = ExitStatus.FAILED;
                            if (startedCount == 0) {
                                jobStatus = steps.size() > 0 ? ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.") : ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
                            } else if (currentStepExecution != null) {
                                jobStatus = currentStepExecution.getExitStatus();
                            }
                            execution.setEndTime(new Date());
                            execution.setExitStatus(jobStatus);
                            this.jobRepository.saveOrUpdate(execution);
                            throw throwable;
                        }
                        jobStatus = ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.");
                        break block29;
                    }
                    jobStatus = ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
                    break block29;
                }
                if (currentStepExecution != null) {
                    jobStatus = currentStepExecution.getExitStatus();
                }
            }
            execution.setEndTime(new Date());
            execution.setExitStatus(jobStatus);
            this.jobRepository.saveOrUpdate(execution);
        }
        if (transaction == null) return;
        try {
            if (jobStatus.equals((Object)ExitStatus.FAILED)) {
                this.transactionManager.rollback(transaction);
                return;
            }
            this.transactionManager.commit(transaction);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error detected during commit/rollback", e);
        }
    }

    private void updateStatus(JobExecution jobExecution, BatchStatus status) {
        jobExecution.setStatus(status);
        this.jobRepository.saveOrUpdate(jobExecution);
    }

    private boolean shouldStart(JobInstance jobInstance, Step step) throws JobExecutionException {
        StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, step);
        BatchStatus stepStatus = lastStepExecution == null ? BatchStatus.STARTING : lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobExecutionException("Cannot restart step from UNKNOWN status.  The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed.  Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED && !step.isAllowStartIfComplete()) {
            return false;
        }
        if (this.jobRepository.getStepExecutionCount(jobInstance, step) < step.getStartLimit()) {
            return true;
        }
        throw new StartLimitExceededException("Maximum start limit exceeded for step: " + step.getName() + "StartMax: " + step.getStartLimit());
    }

    private static void rethrow(Throwable t) throws RuntimeException {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UnexpectedJobExecutionException("Unexpected checked exception in job execution", t);
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }
}

