/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.batch;

import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.util.Assert;

public class StoppableTaskletStep
extends AbstractStep {
    private Tasklet tasklet;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.tasklet, (String)"Tasklet is mandatory for TaskletStep");
        if (this.tasklet instanceof StepExecutionListener) {
            this.registerStepExecutionListener((StepExecutionListener)this.tasklet);
        }
    }

    public StoppableTaskletStep() {
    }

    public StoppableTaskletStep(Tasklet tasklet, JobRepository jobRepository) {
        this();
        this.tasklet = tasklet;
        this.setJobRepository(jobRepository);
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
    }

    protected ExitStatus doExecute(StepExecution stepExecution) throws Exception {
        ExitStatus status = this.tasklet.execute();
        if (status.getExitCode().equals(ExitStatus.FAILED.getExitCode())) {
            stepExecution.setTerminateOnly();
        }
        return status;
    }

    protected void close(ExecutionContext ctx) throws Exception {
    }

    protected void open(ExecutionContext ctx) throws Exception {
    }
}

