/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.cryto;

import es.capgemini.generalitat.common.cryto.exception.CryptoException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class CryptoUtil {
    private static final String CLAU_COMPARTIDA = "abcd5jtg10fki15ksp20ed24";
    private static Provider[] providers = null;
    private static Logger logger = Logger.getLogger(CryptoUtil.class);
    private static final String ALG_TRIPLE_DES = "DESede";

    private CryptoUtil() {
    }

    public static String encrypt(String plaintext) throws CryptoException {
        byte[] sha;
        if (plaintext == null || plaintext.length() == 0) {
            throw new CryptoException("exception.cryptoUtilTextoVacio");
        }
        try {
            sha = DigestUtils.sha((byte[])plaintext.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoException(e, e.getMessage());
        }
        byte[] encoded = Base64.encodeBase64((byte[])sha);
        return new String(encoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String cifra(String message, String algoritme) {
        String str = null;
        if (message != null && !message.equals("")) {
            SecretKeySpec skeySpec = new SecretKeySpec(CLAU_COMPARTIDA.getBytes(), algoritme);
            Cipher cipher = null;
            byte[] output = null;
            try {
                CryptoUtil.loadProviders(algoritme);
                if (providers != null && providers.length > 0) {
                    cipher = Cipher.getInstance(algoritme, providers[0]);
                    cipher.init(1, skeySpec);
                    byte[] input = message.getBytes();
                    output = cipher.doFinal(input, 0, input.length);
                }
                logger.info((Object)"Compte, no hi ha cap proveidor de seguretat carregat!!!!!!");
            }
            catch (Throwable t) {
                logger.error((Object)("Error al xifrar amb l'algoritme " + algoritme), t);
            }
            finally {
                str = CryptoUtil.asHex(output);
            }
        } else {
            str = "";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String descifra(String message, String algoritme) {
        String str;
        block7: {
            str = null;
            if (message != null && !message.equals("")) {
                SecretKeySpec skeySpec = new SecretKeySpec(CLAU_COMPARTIDA.getBytes(), algoritme);
                Cipher cipher = null;
                byte[] output = null;
                try {
                    CryptoUtil.loadProviders(algoritme);
                    if (providers == null || providers.length <= 0) {
                        logger.info((Object)"Compte, no hi ha cap proveidor de seguretat carregat!!!!!!");
                        throw new Throwable("No hi ha cap proveidor de seguretat carregat");
                    }
                    cipher = Cipher.getInstance(algoritme, providers[0]);
                    cipher.init(2, skeySpec);
                    byte[] input = CryptoUtil.asByteArray(message);
                    output = cipher.doFinal(input, 0, input.length);
                    str = new String(output);
                    break block7;
                }
                catch (Throwable t) {
                    try {
                        logger.error((Object)("Error al desxifrar amb l'algoritme " + algoritme), t);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        str = new String(output);
                    }
                }
            }
            str = "";
        }
        return str;
    }

    private static void loadProviders(String algoritmeEncriptacio) {
        if (providers == null) {
            providers = Security.getProviders("Cipher." + algoritmeEncriptacio);
            logger.info((Object)"Llista de proveidors de seguretat amb servei de xifrat:");
            for (int i = 0; i < providers.length; ++i) {
                logger.info((Object)providers[i].getName());
            }
        }
    }

    private static String asHex(byte[] buf) {
        if (buf == null) {
            return "";
        }
        BigInteger bi = new BigInteger(buf);
        return bi.toString(16);
    }

    private static byte[] asByteArray(String message) {
        BigInteger bi = new BigInteger(message, 16);
        byte[] result = bi.toByteArray();
        return result;
    }

    public static String cifraTripleDes(String message) throws Exception {
        return CryptoUtil.cifra(message, ALG_TRIPLE_DES);
    }

    public static String descifraTripleDes(String message) throws Exception {
        return CryptoUtil.descifra(message, ALG_TRIPLE_DES);
    }

    public static String decodeUTF8(String encodedText) throws CryptoException {
        if (encodedText == null || encodedText.length() == 0) {
            throw new CryptoException("exception.cryptoUtilTextoVacio");
        }
        byte[] decoded = Base64.decodeBase64((byte[])encodedText.getBytes());
        try {
            return new String(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(decoded);
        }
    }

    public static String decode(String encodedText) throws CryptoException {
        if (encodedText == null || encodedText.length() == 0) {
            throw new CryptoException("exception.cryptoUtilTextoVacio");
        }
        byte[] decoded = Base64.decodeBase64((byte[])encodedText.getBytes());
        return new String(decoded);
    }

    public static String encode(String plaintext) throws CryptoException {
        if (plaintext == null || plaintext.length() == 0) {
            throw new CryptoException("exception.cryptoUtilTextoVacio");
        }
        byte[] encoded = Base64.encodeBase64((byte[])plaintext.getBytes());
        return new String(encoded);
    }
}

