/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.hibernate.dao;

import es.capgemini.generalitat.common.hibernate.pagination.ManagerPagination;
import es.capgemini.generalitat.common.hibernate.pagination.Page;
import es.capgemini.generalitat.common.hibernate.pagination.PaginationParams;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gencat.ctti.canigo.services.persistence.exception.PersistenceServiceException;
import net.gencat.ctti.canigo.services.validation.exception.ValidationServiceException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DaoAbstractHibernate<DomainObject extends Serializable, KeyType extends Serializable>
extends HibernateDaoSupport {
    private Class<DomainObject> domainClass = this.getDomainClass();
    private ManagerPagination<DomainObject> managerPagination;

    protected Class<DomainObject> getDomainClass() {
        Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return type.getClass();
    }

    public DomainObject get(KeyType id) {
        return (DomainObject)((Serializable)this.getHibernateTemplate().get(this.domainClass, id));
    }

    public List<DomainObject> getList() {
        return this.getSession().createQuery("from " + this.domainClass.getName()).list();
    }

    public void saveOrUpdate(DomainObject t) {
        this.getHibernateTemplate().saveOrUpdate(t);
    }

    public KeyType save(DomainObject t) {
        return (KeyType)this.getHibernateTemplate().save(t);
    }

    public void delete(DomainObject object) {
        this.getHibernateTemplate().delete(object);
    }

    public void deleteById(KeyType id) {
        DomainObject object = this.get(id);
        this.delete(object);
    }

    public DomainObject load(KeyType id) {
        return (DomainObject)((Serializable)this.getHibernateTemplate().load(this.domainClass, id));
    }

    public void update(DomainObject object) {
        this.getHibernateTemplate().update(object);
    }

    public List<DomainObject> getList(boolean cacheable) {
        return this.getSession().createQuery("from " + this.domainClass.getName()).setCacheable(cacheable).list();
    }

    public void deleteAll() {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                String hqlDelete = "delete " + DaoAbstractHibernate.this.domainClass.getName();
                session.createQuery(hqlDelete).executeUpdate();
                return null;
            }
        });
    }

    public int count() {
        List list = this.getHibernateTemplate().find("select count(*) from " + this.domainClass.getName() + " x");
        Integer count = (Integer)list.get(0);
        return count;
    }

    protected Page<DomainObject> getHibernatePage(String query, PaginationParams dto, HashMap<String, Object> params) {
        return this.managerPagination.getHibernatePage(this.getHibernateTemplate(), query, dto, params);
    }

    public void setPaginationManager(ManagerPagination<DomainObject> managerPagination) {
        this.managerPagination = managerPagination;
    }

    protected List<DomainObject> find(final String hql, final Map<String, Object> params) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(hql);
                DaoAbstractHibernate.this.setParameters(query, params);
                return query.list();
            }
        });
    }

    protected DomainObject findUnique(String hql, Map<String, Object> params) {
        return this.findUnique(hql, params, false);
    }

    protected DomainObject findUnique(final String hql, final Map<String, Object> params, final boolean force) {
        return (DomainObject)((Serializable)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(hql);
                DaoAbstractHibernate.this.setParameters(query, params);
                if (force) {
                    query.setMaxResults(1);
                }
                return query.uniqueResult();
            }
        }));
    }

    protected List<DomainObject> find(final String hql, final Map<String, Object> params, final int maxResults) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(hql);
                DaoAbstractHibernate.this.setParameters(query, params);
                query = query.setMaxResults(maxResults);
                return query.list();
            }
        });
    }

    protected void setParameters(Query query, Map<String, Object> parameters) {
        if (parameters == null) {
            return;
        }
        for (String key : parameters.keySet()) {
            Object param = parameters.get(key);
            query.setParameter(key, param);
        }
    }

    protected Date parseFecha(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Date fecha = null;
        try {
            fecha = sdf.parse(date);
        }
        catch (ParseException e) {
            throw new ValidationServiceException("Fecha invalida: " + fecha);
        }
        return fecha;
    }

    public List<DomainObject> buscar(Map<String, String> campos) {
        StringBuffer query = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String className = this.getDomainClass().getName().replace(this.domainClass.getPackage().getName() + ".", "");
        query.append("from " + className + " obj where 1=1 ");
        for (String campo : campos.keySet()) {
            Object param;
            Field field;
            String value = campos.get(campo);
            try {
                field = this.getDomainClass().getDeclaredField(campo);
            }
            catch (Exception e) {
                throw new PersistenceServiceException("No se puede obtener el campo " + campo + "del elemento " + this.domainClass.getName());
            }
            if (field.getType().equals(Date.class)) {
                param = this.parseFecha(value);
                query.append(" and trunc(obj." + campo + ") = trunc(:param" + campo + ")");
            } else if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
                param = Boolean.parseBoolean(value);
                query.append(" and obj." + campo + " is :param" + campo + "");
            } else {
                param = value;
                query.append(" and obj." + campo + " = :param" + campo + "");
            }
            params.put("param" + campo, param);
        }
        return this.find(query.toString(), params);
    }

    public void merge(DomainObject object) {
        this.getHibernateTemplate().merge(object);
    }
}

