/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.hibernate.dao;

import es.capgemini.generalitat.common.hibernate.auditoria.AuditableDomain;
import es.capgemini.generalitat.common.hibernate.dao.DaoAbstractHibernate;
import es.capgemini.generalitat.common.hibernate.dao.DaoAuditable;
import es.capgemini.generalitat.common.security.SecurityUtil;
import java.io.Serializable;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DaoAuditableAbstract<a extends AuditableDomain, keyType extends Serializable>
extends DaoAbstractHibernate<AuditableDomain, Long>
implements DaoAuditable<AuditableDomain, Long> {
    private static final String DEFAULT_USER = "BATCH_USER";

    @Override
    public void saveOrUpdate(AuditableDomain t) {
        if (t.getFechaAlta() == null && t.getUsuarioAlta() == null) {
            t.setFechaAlta(new Timestamp(System.currentTimeMillis()));
            t.setUsuarioAlta(this.getCurrentUserName());
        }
        t.setFechaModificacion(new Timestamp(System.currentTimeMillis()));
        t.setUsuarioModificacion(this.getCurrentUserName());
        super.saveOrUpdate(t);
    }

    @Override
    public Long save(AuditableDomain t) {
        t.setFechaAlta(new Timestamp(System.currentTimeMillis()));
        t.setUsuarioAlta(this.getCurrentUserName());
        return (Long)super.save(t);
    }

    @Override
    public void update(AuditableDomain t) {
        t.setFechaModificacion(new Timestamp(System.currentTimeMillis()));
        t.setUsuarioModificacion(this.getCurrentUserName());
        super.update(t);
    }

    private String getCurrentUserName() {
        if (SecurityUtil.getCurrentUser() != null) {
            return SecurityUtil.getCurrentUser().getUsername();
        }
        return DEFAULT_USER;
    }
}

