/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.hibernate.pagination;

import es.capgemini.generalitat.common.hibernate.pagination.Page;
import es.capgemini.generalitat.common.hibernate.pagination.PageHibernate;
import es.capgemini.generalitat.common.hibernate.pagination.PaginationParams;
import es.capgemini.generalitat.common.properties.PropertyUtil;
import java.io.Serializable;
import java.util.HashMap;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerPagination<DomainObject extends Serializable> {
    public Page<DomainObject> getHibernatePage(HibernateTemplate template, String queryString, PaginationParams paginationParams, HashMap<String, Object> params) {
        if (paginationParams.getLimit() == -1) {
            paginationParams.setLimit(ManagerPagination.getLimitePaginado());
        }
        PageHibernate page = new PageHibernate(queryString, paginationParams, params);
        template.executeFind(page);
        return page;
    }

    public Page<DomainObject> getHibernatePage(HibernateTemplate template, String queryString, PaginationParams paginationParams) {
        if (paginationParams.getLimit() == -1) {
            paginationParams.setLimit(ManagerPagination.getLimitePaginado());
        }
        PageHibernate page = new PageHibernate(queryString, paginationParams);
        template.executeFind(page);
        return page;
    }

    public static int getLimitePaginado() {
        return PropertyUtil.getPropertyAsInt("paginado.limite");
    }

    public static int getLimitePaginadoExportacion() {
        return PropertyUtil.getPropertyAsInt("paginado.export.limite");
    }

    public static int getLimiteCaracteres() {
        return PropertyUtil.getPropertyAsInt("caracteres.limite");
    }
}

