/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.hibernate.pagination;

import es.capgemini.generalitat.common.hibernate.pagination.PageImpl;
import es.capgemini.generalitat.common.hibernate.pagination.PaginationParams;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageHibernate<DomainObject extends Serializable>
extends PageImpl<DomainObject>
implements HibernateCallback {
    private static final long serialVersionUID = -1893600984692969601L;
    private HashMap<String, Object> parameters = new HashMap();

    public PageHibernate() {
    }

    public PageHibernate(String queryString, PaginationParams paginationParams) {
        if (paginationParams.getLimit() > 0) {
            this.setResultsPerPage(paginationParams.getLimit());
        }
        this.setQueryString(queryString);
        this.setFirstResult(paginationParams.getStart() * paginationParams.getLimit());
        this.setDir(paginationParams.getDir());
        this.setSortColumn(paginationParams.getSort());
    }

    public PageHibernate(String queryString, PaginationParams paginationParams, HashMap<String, Object> parameters) {
        if (paginationParams.getLimit() > 0) {
            this.setResultsPerPage(paginationParams.getLimit());
        }
        this.setQueryString(queryString);
        this.setFirstResult(paginationParams.getStart() * paginationParams.getLimit());
        this.setDir(paginationParams.getDir());
        this.setSortColumn(paginationParams.getSort());
        this.parameters = parameters;
    }

    public final Object doInHibernate(Session session) {
        String queryStr = this.creaQuery();
        Query query = session.createQuery(queryStr);
        this.setParameters(query);
        query.setFirstResult(this.getFirstResult());
        query.setMaxResults(this.getResultsPerPage());
        Query q = session.createQuery(this.createQueryForCount(this.getQueryString()));
        this.setParameters(q);
        List count = q.list();
        this.setTotalCount(Integer.parseInt(count.get(0).toString()));
        this.setResults(query.list());
        return this.getResults();
    }

    private void setParameters(Query query) {
        if (this.parameters == null) {
            return;
        }
        for (String key : this.parameters.keySet()) {
            Object param = this.parameters.get(key);
            query.setParameter(key, param);
        }
    }

    private String createQueryForCount(String query) {
        StringBuffer queryR = new StringBuffer();
        if (query.toUpperCase().indexOf("SELECT") >= 0) {
            int fromOn = query.toUpperCase().indexOf("FROM");
            queryR.append("select count(*) ").append(query.substring(fromOn));
        } else {
            queryR.append("select count(*) ").append(query);
        }
        return queryR.toString();
    }

    private String creaQuery() {
        if (this.getSortColumn() == null || this.getQueryString().toUpperCase().indexOf("ORDER BY") > 0) {
            return this.getQueryString();
        }
        String order = "ASC";
        if (this.getDir() != null) {
            order = this.getDir();
        }
        return this.getQueryString() + " order by " + this.getSortColumn() + " " + order;
    }
}

