/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.hibernate.procedure;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.gencat.ctti.canigo.services.persistence.exception.PersistenceServiceException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoProcedure
extends HibernateDaoSupport {
    public List<Object> invokeProcedure(String procedureName, List<Object> inParams, List<Integer> outParams) {
        Connection con = this.getSession().connection();
        CallableStatement proc = null;
        int cantInParams = 0;
        int cantOutParams = 0;
        if (inParams != null) {
            cantInParams = inParams.size();
        }
        if (outParams != null) {
            cantOutParams = outParams.size();
        }
        ArrayList<Object> ret = new ArrayList();
        try {
            proc = con.prepareCall(this.makeCall(procedureName, cantInParams, cantOutParams));
            int index = this.setInParameters(proc, inParams);
            this.setOutParameters(proc, outParams, index);
            proc.execute();
            ret = this.setOutReturn(proc, outParams, index);
        }
        catch (SQLException e) {
            throw new PersistenceServiceException((Throwable)e, "Error al ejecutar el procedure");
        }
        return ret;
    }

    private int setInParameters(CallableStatement proc, List<Object> params) throws SQLException {
        int i = 0;
        if (params == null) {
            return i;
        }
        for (Object param : params) {
            ++i;
            if (param == null) continue;
            if (param instanceof Integer) {
                proc.setInt(i, (int)((Integer)param));
            }
            if (param instanceof Long) {
                proc.setLong(i, (long)((Long)param));
            }
            if (param instanceof String) {
                proc.setString(i, ((String)param).toString());
            }
            if (param instanceof Date) {
                proc.setDate(i, new java.sql.Date(((Date)param).getTime()));
            }
            if (!(param instanceof BigDecimal)) continue;
            proc.setBigDecimal(i, (BigDecimal)param);
        }
        return i;
    }

    private void setOutParameters(CallableStatement proc, List<Integer> params, int index) throws SQLException {
        int i = index;
        if (params == null) {
            return;
        }
        for (Integer param : params) {
            ++i;
            if (param == null) continue;
            proc.registerOutParameter(i, (int)param);
        }
    }

    private List<Object> setOutReturn(CallableStatement proc, List<Integer> params, int index) throws SQLException {
        int i = index;
        ArrayList<Object> ret = new ArrayList<Object>();
        if (params == null) {
            return ret;
        }
        for (Integer param : params) {
            java.sql.Date d;
            ++i;
            if (param == null) continue;
            if (param == 4) {
                ret.add(new Integer(proc.getInt(i)));
            }
            if (param == -5) {
                ret.add(new Long(proc.getLong(i)));
            }
            if (param == 12) {
                ret.add(proc.getString(i));
            }
            if (param == 91 && (d = proc.getDate(i)) != null) {
                ret.add(new Date(d.getTime()));
            }
            if (param == 3) {
                ret.add(proc.getBigDecimal(i));
            }
            if (param != -10) continue;
            ret.add(proc.getObject(i));
        }
        return ret;
    }

    private String makeCall(String procedureName, int cantParamsIn, int cantParamsOut) {
        StringBuffer sb = new StringBuffer();
        sb.append("{ call ").append(procedureName);
        sb.append(" (");
        for (int i = 0; i < cantParamsIn + cantParamsOut; ++i) {
            if (i < cantParamsIn + cantParamsOut - 1) {
                sb.append("?,");
                continue;
            }
            sb.append("?");
        }
        sb.append(")}");
        return sb.toString();
    }
}

