/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.jbpm;

import es.capgemini.generalitat.common.jbpm.JbpmFactoryLocator;
import es.capgemini.generalitat.common.jbpm.ProcessDefinitionFactoryBean;
import es.capgemini.generalitat.common.properties.PropertyUtil;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.configuration.ValueInfo;
import org.jbpm.graph.def.ProcessDefinition;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.core.io.Resource;
import org.springmodules.workflow.jbpm31.JbpmUtils;

public class LocalJbpmConfigurationFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean,
BeanFactoryAware,
BeanNameAware {
    private static final Log LOGGER = LogFactory.getLog(LocalJbpmConfigurationFactoryBean.class);
    private JbpmConfiguration jbpmConfiguration;
    private ObjectFactory objectFactory;
    private Resource configuration;
    private boolean createSchema;
    private boolean dropSchema;
    private boolean hasPersistenceService;
    private String contextName = "default.jbpm.context";
    private Resource[] processDefinitionsResources;
    private ProcessDefinition[] processDefinitions;
    private SessionFactory sessionFactory;
    private final JbpmFactoryLocator factoryLocator = new JbpmFactoryLocator();
    private BeanFactoryReference reference;
    private String factoryKey = JbpmFactoryLocator.class.getName();
    private boolean startJobExecutor = true;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.factoryLocator.setBeanFactory(beanFactory);
        this.reference = this.factoryLocator.useBeanFactory(this.factoryKey);
    }

    public void setBeanName(String name) {
        this.factoryLocator.setBeanName(name);
        this.factoryKey = name;
    }

    public void destroy() throws Exception {
        this.reference.release();
        if (this.dropSchema && this.hasPersistenceService) {
            LOGGER.info((Object)"dropping schema");
            this.jbpmConfiguration.dropSchema(this.contextName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        ObjectFactory jbpmObjectFactory;
        if (this.configuration == null && this.objectFactory == null) {
            throw new IllegalArgumentException("configuration or objectFactory property need to be not null");
        }
        if (this.configuration != null) {
            LOGGER.info((Object)("creating JbpmConfiguration from resource " + this.configuration.getDescription()));
            InputStream stream = this.configuration.getInputStream();
            jbpmObjectFactory = ObjectFactoryParser.parseInputStream((InputStream)stream);
            stream.close();
        } else {
            jbpmObjectFactory = this.objectFactory;
        }
        this.jbpmConfiguration = LocalJbpmConfigurationFactoryBean.createJbpmConfiguration(jbpmObjectFactory);
        JbpmContext context = null;
        try {
            context = this.jbpmConfiguration.createJbpmContext(this.contextName);
            if (this.sessionFactory != null) {
                LOGGER.info((Object)"using given Hibernate session factory");
                context.setSessionFactory(this.sessionFactory);
            }
            this.hasPersistenceService = JbpmUtils.hasPersistenceService((JbpmConfiguration)this.jbpmConfiguration, (String)this.contextName);
            if (this.hasPersistenceService) {
                LOGGER.info((Object)"persistence service available...");
                if (this.createSchema) {
                    LOGGER.info((Object)"creating schema");
                    this.jbpmConfiguration.createSchema(this.contextName);
                }
                if (this.processDefinitions != null || this.processDefinitionsResources != null) {
                    if (this.processDefinitions != null) {
                        String toString = Arrays.asList(this.processDefinitions).toString();
                        LOGGER.info((Object)("deploying process definitions:" + toString));
                        for (int i = 0; i < this.processDefinitions.length; ++i) {
                            ProcessDefinition pd = context.getGraphSession().findLatestProcessDefinition(this.processDefinitions[i].getName());
                            if (pd != null && pd.getVersion() >= this.processDefinitions[i].getVersion() && this.processDefinitions[i].getVersion() != -1) continue;
                            this.processDefinitions[i].setVersion(-1);
                            context.deployProcessDefinition(this.processDefinitions[i]);
                        }
                    }
                    if (this.processDefinitionsResources != null) {
                        ProcessDefinitionFactoryBean factory = new ProcessDefinitionFactoryBean();
                        String toString = Arrays.asList(this.processDefinitionsResources).toString();
                        LOGGER.info((Object)("deploying process definitions (from resources):" + toString));
                        for (int i = 0; i < this.processDefinitionsResources.length; ++i) {
                            factory.setDefinitionLocation(this.processDefinitionsResources[i]);
                            factory.afterPropertiesSet();
                            context.deployProcessDefinition((ProcessDefinition)factory.getObject());
                        }
                    }
                }
            } else {
                LOGGER.info((Object)"persistence unavailable not available - schema create/drop and process definition deployment disabled");
            }
            if (this.startJobExecutor) {
                this.jbpmConfiguration.getJobExecutor().start();
            } else {
                LOGGER.warn((Object)"No se va a iniciar el JobExecutor debido a parametros de configuraci\u00f3n.");
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    protected static JbpmConfiguration createJbpmConfiguration(ObjectFactory objectFactory) {
        JbpmConfiguration jbpmConfiguration = new JbpmConfiguration(objectFactory);
        if (objectFactory instanceof ObjectFactoryImpl) {
            ObjectFactoryImpl objectFactoryImpl = (ObjectFactoryImpl)objectFactory;
            ValueInfo jbpmConfigurationInfo = new ValueInfo("jbpmConfiguration", (Object)jbpmConfiguration);
            objectFactoryImpl.addObjectInfo((ObjectInfo)jbpmConfigurationInfo);
        }
        jbpmConfiguration.getJobExecutor().setNbrOfThreads(PropertyUtil.getPropertyAsInt("bpm.jobExecutor.nbrOfThreads"));
        return jbpmConfiguration;
    }

    public Object getObject() throws Exception {
        return this.jbpmConfiguration;
    }

    public Class getObjectType() {
        return JbpmConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Resource getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Resource configuration) {
        this.configuration = configuration;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public boolean isCreateSchema() {
        return this.createSchema;
    }

    public void setCreateSchema(boolean createSchema) {
        this.createSchema = createSchema;
    }

    public boolean isDropSchema() {
        return this.dropSchema;
    }

    public void setDropSchema(boolean dropSchema) {
        this.dropSchema = dropSchema;
    }

    public ProcessDefinition[] getProcessDefinitions() {
        return this.processDefinitions;
    }

    public void setProcessDefinitions(ProcessDefinition[] processDefinitions) {
        this.processDefinitions = processDefinitions;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Resource[] getProcessDefinitionsResources() {
        return this.processDefinitionsResources;
    }

    public void setProcessDefinitionsResources(Resource[] processDefinitionsResources) {
        this.processDefinitionsResources = processDefinitionsResources;
    }

    protected JbpmFactoryLocator getFactoryLocator() {
        return this.factoryLocator;
    }

    public boolean isStartJobExecutor() {
        return this.startJobExecutor;
    }

    public void setStartJobExecutor(boolean startJobExecutor) {
        this.startJobExecutor = startJobExecutor;
    }
}

