/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.jbpm;

import es.capgemini.generalitat.common.jbpm.ManagerProcess;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.svc.Services;
import org.jbpm.util.Clock;
import org.springframework.transaction.annotation.Transactional;
import org.springmodules.workflow.jbpm31.JbpmCallback;
import org.springmodules.workflow.jbpm31.JbpmTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional(readOnly=false)
public class ManagerProcessImpl
implements ManagerProcess {
    private JbpmConfiguration jbpmConfiguration;
    private JbpmTemplate jbpmTemplate;
    private static final String SELECT_TIMER = "select job from org.jbpm.job.Job as job where job.processInstance = :processInstance and name = :name";

    private JbpmTemplate getJbpmTemplate() {
        if (this.jbpmTemplate == null) {
            this.jbpmTemplate = new JbpmTemplate(this.jbpmConfiguration);
            try {
                this.jbpmTemplate.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException("Fallo la creacion de jdbcTemplate");
            }
        }
        return this.jbpmTemplate;
    }

    public void setJbpmConfiguration(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    @Override
    public ProcessInstance newProcessInstance(String name) {
        return this.newProcessInstance(name, null);
    }

    @Override
    public synchronized ProcessInstance newProcessInstance(final String name, final Map variables) {
        return (ProcessInstance)this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                ProcessInstance processInstance = context.newProcessInstance(name);
                if (variables != null) {
                    ContextInstance cn = processInstance.getContextInstance();
                    cn.setVariables(variables);
                }
                processInstance.signal();
                context.save(processInstance);
                return processInstance;
            }
        });
    }

    @Override
    public void save(ProcessInstance processInstance) {
        this.getJbpmTemplate().saveProcessInstance(processInstance);
    }

    @Override
    public ProcessDefinition findLatestProcessDefinition(final String name) {
        return (ProcessDefinition)this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getGraphSession().findLatestProcessDefinition(name);
            }
        });
    }

    @Override
    public ProcessInstance getProcessInstance(final Long id) {
        return (ProcessInstance)this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return context.getGraphSession().getProcessInstance(id.longValue());
            }
        });
    }

    @Override
    public void signal(final Long id) {
        this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                ProcessInstance processInstance = context.getGraphSession().getProcessInstance(id.longValue());
                processInstance.signal();
                context.save(processInstance);
                return null;
            }
        });
    }

    @Override
    public void signalProcess(final Long idProcess, final String transitionName) {
        this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                ProcessInstance processInstance = context.getGraphSession().getProcessInstance(idProcess.longValue());
                if (processInstance.isTerminatedImplicitly()) {
                    return null;
                }
                if (transitionName == null) {
                    processInstance.signal();
                } else {
                    processInstance.signal(transitionName);
                }
                return null;
            }
        });
    }

    @Override
    public Object execute(JbpmCallback callback) {
        return this.getJbpmTemplate().execute(callback);
    }

    @Override
    public void updateTimerDueDate(final ProcessInstance processInstance, final String name, final Date dueDate) {
        this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                Timer timer = ManagerProcessImpl.this.getTimer(context, processInstance, name);
                timer.setDueDate(dueDate);
                Session session = context.getSession();
                session.save((Object)timer);
                return null;
            }
        });
    }

    @Override
    public String getActualNode(final Long idProcess) {
        return (String)this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                ProcessInstance processInstance = context.getGraphSession().getProcessInstance(idProcess.longValue());
                Token token = processInstance.getRootToken();
                return token.getNode().getName();
            }
        });
    }

    @Override
    public void addVariablesToProcess(final Long idProcess, final Map<String, Object> variables) {
        this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                ProcessInstance processInstance = context.getGraphSession().getProcessInstance(idProcess.longValue());
                processInstance.getContextInstance().setVariables(variables);
                return null;
            }
        });
    }

    @Override
    public Object getVariablesToProcess(final Long idProcess, final String variableName) {
        return this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                ProcessInstance processInstance = context.getGraphSession().getProcessInstance(idProcess.longValue());
                return processInstance.getContextInstance().getVariable(variableName);
            }
        });
    }

    @Override
    public Timer getTimer(final ProcessInstance processInstance, final String name) {
        return (Timer)this.getJbpmTemplate().execute(new JbpmCallback(){

            public Object doInJbpm(JbpmContext context) {
                return ManagerProcessImpl.this.getTimer(context, processInstance, name);
            }
        });
    }

    @Override
    public Timer getTimer(JbpmContext context, ProcessInstance processInstance, String name) {
        Session session = context.getSession();
        Query query = session.createQuery(SELECT_TIMER);
        query.setParameter("processInstance", (Object)processInstance);
        query.setParameter("name", (Object)name);
        List timers = query.list();
        if (timers.size() > 1) {
            throw new IllegalArgumentException("More than 1 timer named [" + name + "] for process instance [" + processInstance.getId() + "]");
        }
        if (timers.size() == 0) {
            return null;
        }
        return (Timer)timers.iterator().next();
    }

    @Override
    public Timer createTimer(ExecutionContext executionContext, String name, Date dueDate, String transitionName) {
        Timer timer = new Timer(executionContext.getToken());
        timer.setName(name);
        timer.setTransitionName(transitionName);
        timer.setGraphElement(executionContext.getEventSource());
        timer.setTaskInstance(executionContext.getTaskInstance());
        timer.setProcessInstance(executionContext.getProcessInstance());
        timer.setDueDate(dueDate);
        timer.setLockTime(new Date());
        timer.setExclusive(true);
        SchedulerService schedulerService = (SchedulerService)Services.getCurrentService((String)"scheduler");
        schedulerService.createTimer(timer);
        return timer;
    }

    @Override
    public Timer createTimer(ExecutionContext executionContext, String name, String durationString, String transitionName) {
        BusinessCalendar businessCalendar = new BusinessCalendar();
        Duration duration = new Duration(durationString);
        Date dueDate = businessCalendar.add(Clock.getCurrentTime(), duration);
        return this.createTimer(executionContext, name, dueDate, transitionName);
    }

    @Override
    public void deleteTimer(ExecutionContext executionContext, String name) {
        SchedulerService schedulerService = (SchedulerService)Services.getCurrentService((String)"scheduler");
        schedulerService.deleteTimersByName(name, executionContext.getToken());
    }

    @Override
    public void deleteTimer(ExecutionContext executionContext) {
        SchedulerService schedulerService = (SchedulerService)Services.getCurrentService((String)"scheduler");
        schedulerService.deleteTimersByProcessInstance(executionContext.getProcessInstance());
    }
}

