/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.jbpm;

import java.io.InputStream;
import org.jbpm.graph.def.ProcessDefinition;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class ProcessDefinitionFactoryBean
implements FactoryBean,
InitializingBean {
    private ProcessDefinition processDefinition;
    private Resource definitionLocation;
    private int version = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.definitionLocation == null) {
            throw new FatalBeanException("Property [definitionLocation] of class [" + ProcessDefinitionFactoryBean.class.getName() + "] is required.");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.definitionLocation.getInputStream();
            this.processDefinition = ProcessDefinition.parseXmlInputStream((InputStream)inputStream);
            this.processDefinition.setVersion(this.version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public Object getObject() throws Exception {
        return this.processDefinition;
    }

    public Class getObjectType() {
        if (this.processDefinition == null) {
            return ProcessDefinition.class;
        }
        return this.processDefinition.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setDefinitionLocation(Resource definitionLocation) {
        this.definitionLocation = definitionLocation;
    }
}

