/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.gencat.ctti.canigo.services.logging.Log;
import net.gencat.ctti.canigo.services.logging.LoggingService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class GenericLoggerAspect
implements MethodInterceptor {
    private LoggingService loggingService;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> targetClass = invocation.getThis().getClass();
        String targetName = targetClass.getName();
        Log logger = this.loggingService.getLog(targetClass);
        String methodName = invocation.getMethod().getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(targetName + ":" + methodName + ":Begin Method"));
            Object[] param = invocation.getArguments();
            if (param != null) {
                for (int i = 0; i < param.length; ++i) {
                    if (param[i] != null) {
                        logger.debug((Object)(targetName + ":" + methodName + ":Parameter[" + i + "] Type:" + param[i].getClass().toString() + " Value: " + param[i].toString()));
                        continue;
                    }
                    logger.debug((Object)(targetName + ":" + methodName + ":Parameter[" + i + "] Type: null Value: null"));
                }
            }
        }
        try {
            Object returnObject = invocation.proceed();
            if (logger.isDebugEnabled()) {
                if (returnObject != null) {
                    logger.debug((Object)(targetName + ":" + methodName + ":ReturnValue: Type:" + returnObject.getClass().toString() + " Value:" + returnObject.toString()));
                } else {
                    logger.debug((Object)(targetName + ":" + methodName + ":ReturnValue: null"));
                }
                logger.debug((Object)(targetName + ":" + methodName + ":End Method"));
            }
            return returnObject;
        }
        catch (Throwable ex) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            PrintStream aux = new PrintStream(outStream);
            ex.printStackTrace(aux);
            logger.debug((Object)(targetName + ":" + "LoggerInterceptor:Exception: " + ((Object)outStream).toString()));
            logger.debug((Object)(targetName + ":" + "LoggerInterceptor:Exception: ----------------------------------------------------"));
            throw ex;
        }
    }

    public void setLoggingService(LoggingService loggingService) {
        this.loggingService = loggingService;
    }
}

