/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.manager;

import es.capgemini.generalitat.common.manager.ManagerAbstract;
import es.capgemini.generalitat.common.properties.PropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import net.gencat.ctti.canigo.services.exceptions.SystemException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

public class ManagerCache
extends ManagerAbstract {
    private Resource resource;
    private boolean cacheCargada = false;
    private boolean leerSocketUTF8 = PropertyUtil.getPropertyAsBoolean("encoding.readFromSocket.UTF8");
    private boolean leerDiscUTF8 = PropertyUtil.getPropertyAsBoolean("encoding.readFromDisc.UTF8");

    public void actualizarCache() {
        try {
            FileInputStream f = new FileInputStream(this.resource.getFile());
            Properties propiedades = new Properties();
            propiedades.load(f);
            f.close();
            this.validaDirectorio(PropertyUtil.getProperty("cache.path"));
            Enumeration<Object> e = propiedades.keys();
            while (e.hasMoreElements()) {
                String propiedad;
                String obj = (String)e.nextElement();
                if (!obj.contains("element.") || (propiedad = propiedades.getProperty(obj)) == null || "".equals(propiedad) || "".equals(obj)) continue;
                this.actualizarPagina(obj, propiedades.getProperty(obj));
            }
            this.cacheCargada = true;
            this.getLogger().info((Object)"Se ha actualizado la cache de las paginas.");
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error al actualizar la cache.", (Throwable)e);
        }
    }

    public void actualizarCache(String key) {
        try {
            FileInputStream f = new FileInputStream(this.resource.getFile());
            Properties propiedades = new Properties();
            propiedades.load(f);
            f.close();
            this.validaDirectorio(PropertyUtil.getProperty("cache.path"));
            String propiedad = propiedades.getProperty(key);
            if (propiedad != null && !"".equals(propiedad)) {
                this.actualizarPagina(key, propiedades.getProperty(key));
            }
            this.getLogger().info((Object)("Se ha actualizado la cache de las paginas: " + key));
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error al actualizar la cache.", (Throwable)e);
        }
    }

    private void actualizarPagina(String name, String urlPag) throws SystemException {
        try {
            URL url = new URL(urlPag);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            if (connection.getResponseCode() == 200) {
                byte[] datos;
                InputStreamReader r;
                if (this.leerSocketUTF8) {
                    r = new InputStreamReader(connection.getInputStream());
                    datos = IOUtils.toByteArray((Reader)r, (String)"UTF-8");
                } else {
                    r = new InputStreamReader(connection.getInputStream());
                    datos = IOUtils.toByteArray((Reader)r);
                }
                if (this.validarPagina(datos)) {
                    File temporal = new File(PropertyUtil.getProperty("cache.path") + name + ".html");
                    FileUtils.writeByteArrayToFile((File)temporal, (byte[])datos);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new SystemException((Throwable)e, "No se puede crear el fichero de la cache, revise la configuracion y los permisos sobre los path");
        }
        catch (MalformedURLException e) {
            throw new SystemException((Throwable)e, "URL de cache invalida, no se puede obtener la misma. Revise la configuracion. Url: " + urlPag);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e, "Error de IO");
        }
    }

    private boolean validarPagina(byte[] pagina) {
        boolean paginaValida = true;
        if (PropertyUtil.getPropertyAsBoolean("cache.validaTitle")) {
            StringBuffer paginaString = new StringBuffer(new String(pagina));
            int titleInit = paginaString.indexOf("<title>");
            int titleEnd = paginaString.indexOf("</title>");
            if (titleInit != -1 && titleEnd != -1 && titleEnd > titleInit + 8) {
                paginaValida = false;
            }
        }
        return paginaValida;
    }

    private void validaDirectorio(String path) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                FileUtils.forceMkdir((File)new File(path));
            }
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e, "Error de IO");
        }
        catch (SecurityException e) {
            throw new SystemException((Throwable)e, "No se puede crear el directorio " + path + ". Permiso denegado por el SO.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getElement(String menu) {
        if (!this.cacheCargada) {
            this.actualizarCache();
        }
        String name = menu;
        FileInputStream fr = null;
        List lines = null;
        try {
            try {
                fr = new FileInputStream(new File(PropertyUtil.getProperty("cache.path") + name + ".html"));
            }
            catch (FileNotFoundException e) {
                this.getLogger().error((Object)"No esta inicializada la cache, se intenta iniciarla.");
                this.actualizarCache(menu);
                try {
                    fr = new FileInputStream(new File(PropertyUtil.getProperty("cache.path") + name + ".html"));
                }
                catch (FileNotFoundException e1) {
                    this.getLogger().error((Object)"No se puede obtener el fichero de la cache. No existe o no es accesible.", (Throwable)e);
                    try {
                        fr = new FileInputStream(new File(PropertyUtil.getProperty("backup.path") + name + ".html"));
                    }
                    catch (FileNotFoundException e2) {
                        this.getLogger().error((Object)"No se puede obtener el fichero del backup. No existe o no  es accesible.", (Throwable)e);
                        e.printStackTrace();
                        throw new SystemException((Throwable)e1, "Imposible actualizar cache");
                    }
                }
            }
            lines = this.leerDiscUTF8 ? IOUtils.readLines((InputStream)fr, (String)"UTF-8") : IOUtils.readLines((InputStream)fr, null);
            StringBuilder salida = new StringBuilder();
            for (String line : lines) {
                salida.append(line);
            }
            String string = salida.toString();
            return string;
        }
        catch (IOException e) {
            this.getLogger().error((Object)"No se puede obtener el fichero de la cache. Error de IO.", (Throwable)e);
        }
        catch (SystemException se) {
            this.getLogger().info((Object)"cache no actualizada, imposible obtener elemento cache");
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                this.getLogger().error((Object)"Error al cerrar los ficheros de la cache.", (Throwable)e);
            }
        }
        return "";
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

