/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.pdf;

import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.core.io.ClassPathResource;
import sun.misc.BASE64Encoder;

public class PdfUtil {
    private PdfUtil() {
    }

    private static String[][] extraccioResumCriptograficSignaturaCMSDetachedDePDF(byte[] docToValidate) throws Exception {
        PdfReader reader = new PdfReader(docToValidate);
        AcroFields af = reader.getAcroFields();
        ArrayList names = af.getSignatureNames();
        String name = "";
        if (names.size() == 0) {
            throw new Exception("Aquest document no cont\u00e9 cap signatura.");
        }
        String[][] ret = new String[names.size()][1];
        for (int k = 0; k < names.size(); ++k) {
            String b64Signature;
            name = (String)names.get(k);
            PdfDictionary v = af.getSignatureDictionary(name);
            PdfString contents = (PdfString)PdfReader.getPdfObject((PdfObject)v.get(PdfName.CONTENTS));
            PdfArray byteRange = (PdfArray)PdfReader.getPdfObject((PdfObject)v.get(PdfName.BYTERANGE));
            CMSSignedData cmSsignature = new CMSSignedData(contents.getOriginalBytes());
            ret[k][0] = b64Signature = new BASE64Encoder().encode(cmSsignature.getEncoded());
        }
        return ret;
    }

    public static byte[] extraccioSignaturaCMSDetachedDePDF(byte[] docToValidate) throws Exception {
        PdfReader reader = new PdfReader(docToValidate);
        AcroFields af = reader.getAcroFields();
        ArrayList names = af.getSignatureNames();
        String name = "";
        byte[] signatura = null;
        if (names.size() == 0) {
            throw new Exception("Aquest document no cont\u00e9 cap signatura.");
        }
        for (int k = 0; k < names.size(); ++k) {
            name = (String)names.get(k);
            PdfDictionary v = af.getSignatureDictionary(name);
            PdfString contents = (PdfString)PdfReader.getPdfObject((PdfObject)v.get(PdfName.CONTENTS));
            PdfArray byteRange = (PdfArray)PdfReader.getPdfObject((PdfObject)v.get(PdfName.BYTERANGE));
            CMSSignedData cmSsignature = new CMSSignedData(contents.getOriginalBytes());
            signatura = cmSsignature.getEncoded();
        }
        return signatura;
    }

    public static byte[] extraccioSignedDataDePDF(byte[] docToValidate) throws Exception {
        PdfReader reader = new PdfReader(docToValidate);
        AcroFields af = reader.getAcroFields();
        ArrayList names = af.getSignatureNames();
        String name = "";
        byte[] dadesSignades = null;
        if (names.size() == 0) {
            throw new Exception("Aquest document no cont\u00e9 cap signatura.");
        }
        for (int k = 0; k < names.size(); ++k) {
            byte[] signedData;
            name = (String)names.get(k);
            PdfDictionary v = af.getSignatureDictionary(name);
            PdfArray byteRange = (PdfArray)PdfReader.getPdfObject((PdfObject)v.get(PdfName.BYTERANGE));
            ArrayList range = byteRange.getArrayList();
            dadesSignades = signedData = PdfUtil.readByteRange(docToValidate, ((PdfNumber)range.get(0)).intValue(), ((PdfNumber)range.get(1)).intValue(), ((PdfNumber)range.get(2)).intValue(), ((PdfNumber)range.get(3)).intValue());
        }
        return dadesSignades;
    }

    private static byte[] readByteRange(byte[] data, int off1, int len1, int off2, int len2) throws Exception {
        byte[] bytes = new byte[len1 + len2];
        System.arraycopy(data, off1, bytes, 0, len1);
        System.arraycopy(data, off2, bytes, len1, len2);
        return bytes;
    }

    private static X509Certificate getSignerCertificate(byte[] p7signature) throws Exception {
        CMSSignedData signature = new CMSSignedData(p7signature);
        SignerInformation signer = (SignerInformation)signature.getSignerInfos().getSigners().iterator().next();
        CertStore cs = signature.getCertificatesAndCRLs("Collection", "BC");
        Iterator<? extends Certificate> iter = cs.getCertificates((CertSelector)signer.getSID()).iterator();
        return (X509Certificate)iter.next();
    }

    public static X509Certificate loadX509Certificate(String certificat) throws Exception {
        ClassPathResource resource = new ClassPathResource(certificat);
        InputStream inStream = resource.getInputStream();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        inStream.close();
        return cert;
    }

    public static X509Certificate loadX509CertificateFromStream(InputStream inStream) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        inStream.close();
        return cert;
    }

    public static X509Certificate obtenirCertificatDePdf(byte[] pdf) throws Exception {
        PdfReader reader = new PdfReader(pdf);
        AcroFields af = reader.getAcroFields();
        ArrayList names = af.getSignatureNames();
        X509Certificate returnCertificate = null;
        if (names.size() == 0) {
            throw new Exception("Aquest document no cont\u00e9 cap signatura.");
        }
        for (String name : names) {
            PdfDictionary v = af.getSignatureDictionary(name);
            PdfString contents = (PdfString)PdfReader.getPdfObject((PdfObject)v.get(PdfName.CONTENTS));
            CMSSignedData signature = new CMSSignedData(contents.getOriginalBytes());
            SignerInformation signer = (SignerInformation)signature.getSignerInfos().getSigners().iterator().next();
            CertStore cs = signature.getCertificatesAndCRLs("Collection", "BC");
            Iterator<? extends Certificate> iter = cs.getCertificates((CertSelector)signer.getSID()).iterator();
            returnCertificate = (X509Certificate)iter.next();
        }
        return returnCertificate;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

