/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.properties;

import java.io.IOException;
import java.util.Properties;
import net.gencat.ctti.canigo.services.configuration.exception.ConfigurationServiceException;
import net.gencat.ctti.canigo.services.configuration.springframework.beans.factory.config.HostPropertyPlaceholderConfigurer;
import net.gencat.ctti.canigo.services.exceptions.ExceptionDetails;
import net.gencat.ctti.canigo.services.exceptions.Layer;
import net.gencat.ctti.canigo.services.exceptions.Subsystem;

public class CommonPropertyPlaceholderConfigurer
extends HostPropertyPlaceholderConfigurer {
    private Properties properties = new Properties();
    private boolean alwaysReload = true;

    public String getProperty(String key) throws ConfigurationServiceException {
        String propertyValue = null;
        try {
            if (this.isAlwaysReload()) {
                propertyValue = this.resolvePlaceholder(key, this.mergeProperties());
            } else {
                propertyValue = this.resolvePlaceholder(key, this.properties);
                if (propertyValue == null) {
                    this.properties = this.mergeProperties();
                    propertyValue = this.resolvePlaceholder(key, this.properties);
                }
            }
        }
        catch (IOException ex) {
            ExceptionDetails exDetails = new ExceptionDetails(ConfigurationServiceException.class.getPackage() + ".no_such_property", new Object[]{key}, Layer.SERVICES, Subsystem.CONFIGURATION_SERVICES);
            this.getLogService().getLog(((Object)((Object)this)).getClass()).error((Object)ex.getCause());
            throw new ConfigurationServiceException((Throwable)ex, exDetails);
        }
        if (propertyValue == null) {
            ExceptionDetails exDetails = new ExceptionDetails(ConfigurationServiceException.class.getPackage() + ".no_such_property", new Object[]{key}, Layer.SERVICES, Subsystem.CONFIGURATION_SERVICES);
            this.getLogService().getLog(((Object)((Object)this)).getClass()).error((Object)("Property [" + key + "] not found"));
            throw new ConfigurationServiceException(exDetails);
        }
        if (this.getLogService().getLog(((Object)((Object)this)).getClass()).isDebugEnabled()) {
            this.getLogService().getLog(((Object)((Object)this)).getClass()).debug((Object)("Getting property value " + propertyValue));
        }
        return propertyValue;
    }

    public boolean isAlwaysReload() {
        return this.alwaysReload;
    }

    public void setAlwaysReload(boolean alwaysReload) {
        this.alwaysReload = alwaysReload;
    }
}

