/*
 * Decompiled with CFR 0.152.
 */
package es.capgemini.generalitat.common.security;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.SecurityContextHolder;
import net.sf.acegisecurity.providers.dao.User;

public class SecurityUtil {
    private SecurityUtil() {
    }

    public static UserDetails getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            return null;
        }
        User u = new User((String)authentication.getPrincipal(), (String)authentication.getCredentials(), true, false, false, false, authentication.getAuthorities());
        return u;
    }

    public static boolean isAnyUserAutheticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.isAuthenticated();
    }

    public static boolean isUserAnonymous() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && "anonymousUser".equals(authentication.getPrincipal());
    }
}

